/*
 * Decompiled with CFR 0.152.
 */
package org.hath.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.hath.base.Settings;
import org.hath.base.StatListener;
import org.hath.base.Stats;
import org.hath.gui.HentaiAtHomeClientGUI;
import org.hath.gui.StorageUnit;

public class HHControlPane
extends JPanel {
    private HentaiAtHomeClientGUI clientGUI;
    private StatPane statPane;
    private GraphPane graphPane;

    public HHControlPane(HentaiAtHomeClientGUI hentaiAtHomeClientGUI) {
        this.clientGUI = hentaiAtHomeClientGUI;
        this.setPreferredSize(new Dimension(1000, 220));
        this.setLayout(new BorderLayout());
        this.statPane = new StatPane();
        this.graphPane = new GraphPane();
        this.add((Component)this.statPane, "Before");
        this.add((Component)this.graphPane, "Center");
    }

    public void updateData() {
        this.statPane.updateStats();
    }

    private class GraphPane
    extends JPanel
    implements StatListener {
        private int[] heights;
        private long lastGraphRefresh = 0L;
        private long bytesLast10Sec = 0L;
        private long bytesLastMin = 0L;
        private long bytesLast15Min = 0L;
        private long bytesLast60Min = 0L;
        private Font myFont;

        public GraphPane() {
            this.setMinimumSize(new Dimension(500, 220));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Beautiful Line"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.getBorder()));
            Stats.addStatListener(this);
            this.repaint();
        }

        @Override
        public void statChanged(String string) {
            if (string.equals("bytesSentHistory")) {
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            if (!HHControlPane.this.clientGUI.isShowing()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
            if (this.myFont == null) {
                this.myFont = new Font("Sans-serif", 0, 10);
            }
            graphics2D.setFont(this.myFont);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.clearRect(15, 15, this.getWidth() - 20, 180);
            int n3 = 10;
            int n4 = this.getWidth() - 20;
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(n3, 20, n4, 170);
            graphics2D.setColor(Color.GREEN);
            graphics2D.drawRect(n3, 20, n4, 170);
            graphics2D.setColor(Color.GRAY);
            int n5 = n4 / 6;
            for (int i = 1; i <= 5; ++i) {
                int n6 = n3 + n5 * i;
                graphics2D.drawLine(n6, 21, n6, 189);
            }
            double d = (double)(n4 - 2) / 359.0;
            int n7 = n3 + 1;
            int n8 = 189;
            int n9 = 21;
            int n10 = n8 - n9;
            int n11 = -1;
            if (this.heights == null || this.lastGraphRefresh < System.currentTimeMillis() - 10000L) {
                this.heights = new int[360];
                int[] nArray = Stats.getBytesSentHistory();
                this.bytesLast10Sec = nArray[1];
                this.bytesLastMin = 0L;
                this.bytesLast15Min = 0L;
                this.bytesLast60Min = 0L;
                double d2 = 0.0;
                if (Settings.getThrottleBytesPerSec() > 0 || Stats.getBytesSentPerSec() > 0) {
                    d2 = Math.min((double)Settings.getThrottleBytesPerSec() * 10.0, (double)Stats.getBytesSentPerSec() * 30.0);
                }
                if (d2 == 0.0) {
                    d2 = 200000.0;
                }
                double d3 = 0.0;
                n2 = 0;
                for (int i = 360; i > 0; --i) {
                    int n12 = nArray[i];
                    this.heights[n2++] = (int)Math.round((double)n12 / d2 * (double)n10);
                    d3 = Math.max((double)n12, d3);
                    this.bytesLast60Min += (long)n12;
                    if (i > 90) continue;
                    this.bytesLast15Min += (long)n12;
                    if (i > 6) continue;
                    this.bytesLastMin += (long)n12;
                }
                if (d3 > d2) {
                    double d4 = d2 / d3;
                    for (int i = 0; i < 360; ++i) {
                        this.heights[i] = (int)Math.round((double)this.heights[i] * d4);
                    }
                }
                n11 = (int)Math.ceil(Math.max(d2, d3) / 10000.0);
            }
            if (this.heights != null) {
                int n13;
                graphics2D.setColor(Color.GREEN);
                int n14 = 0;
                int n15 = (int)Math.round((double)n7 + d * 0.0);
                n = 0;
                int n16 = Math.round(n8 - this.heights[0]);
                for (n13 = 0; n13 < 359; ++n13) {
                    n14 = n15;
                    n15 = (int)Math.round((double)n7 + d * (double)(n13 + 1));
                    n = n16;
                    n16 = Math.round(n8 - this.heights[n13 + 1]);
                    graphics2D.drawLine(n14, n, n15, n16);
                }
                graphics2D.setColor(Color.PINK);
                n13 = (this.heights[0] + this.heights[1] + this.heights[2] + this.heights[3] + this.heights[4] + this.heights[5]) / 6;
                n14 = 0;
                n15 = (int)Math.round((double)n7 + d * 0.0);
                n = 0;
                n16 = Math.round(n8 - n13);
                for (n2 = 0; n2 < 359; ++n2) {
                    if (n2 < 354) {
                        n13 = Math.max(0, n13 + (this.heights[n2 + 6] - this.heights[n2]) / 6);
                    }
                    n14 = n15;
                    n15 = (int)Math.round((double)n7 + d * (double)(n2 + 1));
                    n = n16;
                    n16 = Math.round(n8 - n13);
                    graphics2D.drawLine(n14, n, n15, n16);
                }
                graphics2D.setColor(Color.BLACK);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                long l = Stats.getUptime();
                graphics2D.drawString("60 min: " + (!Stats.isClientRunning() || l < 3600L ? "N/A" : decimalFormat.format((double)this.bytesLast60Min / 3600000.0)) + " KB/s", 10, 205);
                graphics2D.drawString("15 min: " + (!Stats.isClientRunning() || l < 900L ? "N/A" : decimalFormat.format((double)this.bytesLast15Min / 900000.0)) + " KB/s", 135, 205);
                graphics2D.drawString("1 min: " + (!Stats.isClientRunning() || l < 60L ? "N/A" : decimalFormat.format((double)this.bytesLastMin / 60000.0)) + " KB/s", 260, 205);
                graphics2D.drawString("Last: " + (!Stats.isClientRunning() ? "N/A" : decimalFormat.format((double)this.bytesLast10Sec / 10000.0)) + " KB/s", 385, 205);
            }
            if (n11 > -1) {
                graphics2D.setColor(Color.RED);
                int n17 = n9 + 12;
                int n18 = (int)((double)n9 + (double)n10 * 0.25) + 12;
                n = (int)((double)n9 + (double)n10 * 0.5) + 12;
                int n19 = (int)((double)n9 + (double)n10 * 0.75) + 12;
                graphics2D.drawString(n11 + " KB/s", 15, n17);
                graphics2D.drawLine(11, n17 - 11, n4 + 9, n17 - 11);
                graphics2D.drawString((int)((double)n11 * 0.75) + " KB/s", 15, n18);
                graphics2D.drawLine(11, n18 - 11, n4 + 9, n18 - 11);
                graphics2D.drawString((int)((double)n11 * 0.5) + " KB/s", 15, n);
                graphics2D.drawLine(11, n - 11, n4 + 9, n - 11);
                graphics2D.drawString((int)((double)n11 * 0.25) + " KB/s", 15, n19);
                graphics2D.drawLine(11, n19 - 11, n4 + 9, n19 - 11);
            }
        }
    }

    private class StatPane
    extends JPanel
    implements StatListener {
        private Font myFont;

        public StatPane() {
            this.setPreferredSize(new Dimension(500, 220));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Program Stats"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.getBorder()));
            Stats.addStatListener(this);
            this.repaint();
        }

        @Override
        public void statChanged(String string) {
            this.repaint(10L);
        }

        public void updateStats() {
            this.repaint(10L);
        }

        @Override
        public void paint(Graphics graphics) {
            if (!HHControlPane.this.clientGUI.isShowing()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
            if (this.myFont == null) {
                this.myFont = new Font("Sans-serif", 0, 10);
            }
            graphics2D.setFont(this.myFont);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.BLACK);
            int n = 20;
            int n2 = 30;
            int n3 = 25;
            int n4 = 110;
            int n5 = 90;
            int n6 = n;
            int n7 = n6 + n4;
            int n8 = n7 + n5;
            int n9 = n8 + n4;
            graphics2D.drawString("Client Status", n6, n2 + n3 * 0);
            graphics2D.drawString("Uptime", n6, n2 + n3 * 1);
            graphics2D.drawString("Last Server Contact", n8, n2 + n3 * 1);
            graphics2D.drawString("Total Files Sent", n6, n2 + n3 * 2);
            graphics2D.drawString("Total Files Rcvd", n8, n2 + n3 * 2);
            graphics2D.drawString("Total Bytes Sent", n6, n2 + n3 * 3);
            graphics2D.drawString("Total Bytes Rcvd", n8, n2 + n3 * 3);
            graphics2D.drawString("Avg Bytes Sent/Sec", n6, n2 + n3 * 4);
            graphics2D.drawString("Avg Bytes Rcvd/Sec", n8, n2 + n3 * 4);
            graphics2D.drawString("Files In Cache", n6, n2 + n3 * 5);
            graphics2D.drawString("Used Cache Size", n8, n2 + n3 * 5);
            graphics2D.drawString("Cache Utilization", n6, n2 + n3 * 6);
            graphics2D.drawString("Free Cache Space", n8, n2 + n3 * 6);
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            String string = Stats.getUptime() / 3600 + " hr " + Stats.getUptime() % 3600 / 60 + " min";
            int n10 = Stats.getLastServerContact();
            String string2 = n10 == 0 ? "Never" : (int)(System.currentTimeMillis() / 1000L) - n10 + " sec ago";
            long l = Stats.getBytesSent();
            String string3 = StorageUnit.of(l).format(l);
            long l2 = Stats.getBytesRcvd();
            String string4 = StorageUnit.of(l2).format(l2);
            int n11 = Stats.getBytesSentPerSec();
            String string5 = StorageUnit.of(n11).format(n11) + "/s";
            int n12 = Stats.getBytesRcvdPerSec();
            String string6 = StorageUnit.of(n12).format(n12) + "/s";
            long l3 = Stats.getCacheSize();
            String string7 = StorageUnit.of(l3).format(l3);
            float f = Stats.getCacheFill();
            String string8 = decimalFormat.format(f * 100.0f) + "%";
            long l4 = Stats.getCacheFree();
            String string9 = StorageUnit.of(l4).format(l4);
            graphics2D.drawString(Stats.getProgramStatus(), n7, n2 + n3 * 0);
            graphics2D.drawString(string, n7, n2 + n3 * 1);
            graphics2D.drawString(string2, n9, n2 + n3 * 1);
            graphics2D.drawString(Stats.getFilesSent() + "", n7, n2 + n3 * 2);
            graphics2D.drawString(Stats.getFilesRcvd() + "", n9, n2 + n3 * 2);
            graphics2D.drawString(string3, n7, n2 + n3 * 3);
            graphics2D.drawString(string4, n9, n2 + n3 * 3);
            graphics2D.drawString(string5, n7, n2 + n3 * 4);
            graphics2D.drawString(string6, n9, n2 + n3 * 4);
            graphics2D.drawString(Stats.getCacheCount() + "", n7, n2 + n3 * 5);
            graphics2D.drawString(string7, n9, n2 + n3 * 5);
            graphics2D.drawString(string8, n7, n2 + n3 * 6);
            graphics2D.drawString(string9, n9, n2 + n3 * 6);
            int n13 = Stats.getCurrentBytesPerSec();
            int n14 = Settings.getThrottleBytesPerSec() > 0 ? Settings.getThrottleBytesPerSec() : (Stats.getBytesSentPerSec() > 0 ? Stats.getBytesSentPerSec() * 3 : Integer.MAX_VALUE);
            String string10 = Stats.getOpenConnections() + "";
            String string11 = decimalFormat.format((double)n13 / 1000.0);
            graphics2D.drawRect(410, 40, 30, 150);
            graphics2D.drawString("Conns", 410, 30);
            graphics2D.drawString(string10, 422 - (string10.length() - 1) * 3, 203);
            graphics2D.drawRect(450, 40, 30, 150);
            graphics2D.drawString("KBps", 453, 30);
            graphics2D.drawString(string11, 455 - (string11.length() - 4) * 3, 203);
            this.drawBlipBar(graphics2D, 415, 45, (double)Stats.getOpenConnections() / (double)Settings.getMaxConnections());
            this.drawBlipBar(graphics2D, 455, 45, (double)n13 / (double)n14);
        }

        public void drawBlipBar(Graphics2D graphics2D, int n, int n2, double d) {
            int n3 = 20;
            int n4 = 2;
            int n5 = 5;
            int n6 = n2 + 140;
            int n7 = 0;
            int n8 = Math.min(20, (int)Math.ceil(d * 20.0));
            while (++n7 <= n8) {
                if (n7 < 11) {
                    graphics2D.setColor(Color.GREEN);
                } else if (n7 < 16) {
                    graphics2D.setColor(Color.ORANGE);
                } else {
                    graphics2D.setColor(Color.RED);
                }
                int n9 = n6 - (n5 * n7 + n4 * (n7 - 1));
                graphics2D.fillRect(n, n9, n3, n5);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawRect(n, n9, n3, n5);
            }
        }
    }
}

