/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.hath.base.FileTools;
import org.hath.base.HVFile;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class CacheHandler {
    private HentaiAtHomeClient client;
    private static File cachedir = null;
    private static File tmpdir = null;
    private Connection sqlite = null;
    private int cacheCount;
    private int startupCachedFileStrlen;
    private long cacheSize;
    private boolean quickStart = false;
    protected PreparedStatement cacheIndexClearActive;
    protected PreparedStatement cacheIndexCountStats;
    protected PreparedStatement queryCachelistSegment;
    protected PreparedStatement queryCachedFileLasthit;
    protected PreparedStatement queryCachedFileSortOnLasthit;
    protected PreparedStatement insertCachedFile;
    protected PreparedStatement updateCachedFileLasthit;
    protected PreparedStatement updateCachedFileActive;
    protected PreparedStatement deleteCachedFile;
    protected PreparedStatement deleteCachedFileInactive;
    protected PreparedStatement getStringVar;
    protected PreparedStatement setStringVar;
    protected ArrayList<CachedFile> recentlyAccessed;
    protected ArrayList<HVFile> pendingRegister;
    protected long recentlyAccessedFlush;
    private short[] memoryWrittenTable;
    private int memoryClearPointer;
    private static final String CLEAN_SHUTDOWN_KEY = "clean_shutdown";
    private static final String CLEAN_SHUTDOWN_VALUE = "clean_r81";
    private static final int MEMORY_TABLE_ELEMENTS = 0x100000;

    public CacheHandler(HentaiAtHomeClient hentaiAtHomeClient) throws IOException {
        this.client = hentaiAtHomeClient;
        this.recentlyAccessed = new ArrayList(100);
        this.pendingRegister = new ArrayList(50);
        tmpdir = FileTools.checkAndCreateDir(new File("tmp"));
        cachedir = FileTools.checkAndCreateDir(new File("cache"));
        if (!Settings.isUseLessMemory()) {
            this.memoryWrittenTable = new short[0x100000];
            this.memoryClearPointer = 0;
        }
        Out.info("CacheHandler: Initializing database engine...");
        try {
            if (!this.initializeDatabase("data/hath.db")) {
                Out.info("");
                Out.info("**************************************************************************************************************");
                Out.info("The database could not be loaded. Please check file permissions and file system integrity.");
                Out.info("If everything appears to be working, please do the following:");
                Out.info("1. Locate the directory " + Settings.getDataDir().getAbsolutePath());
                Out.info("2. Delete the file hath.db");
                Out.info("3. Restart the client.");
                Out.info("The system should now rebuild the database.");
                Out.info("***************************************************************************************************************");
                Out.info("");
                HentaiAtHomeClient.dieWithError("Failed to load the database.");
            }
            if (this.quickStart) {
                Out.info("Last shutdown was clean - using fast startup procedure.");
            } else {
                Out.info("Last shutdown was dirty - the cache index must be verified.");
            }
            Out.info("CacheHandler: Database initialized");
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to initialize SQLite database engine");
            HentaiAtHomeClient.dieWithError(exception);
        }
    }

    private boolean initializeDatabase(String string) {
        try {
            Object object;
            Out.info("CacheHandler: Loading database from " + string);
            Class.forName("org.sqlite.JDBC");
            this.sqlite = DriverManager.getConnection("jdbc:sqlite:" + string);
            DatabaseMetaData databaseMetaData = this.sqlite.getMetaData();
            Out.info("CacheHandler: Using " + databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion() + " over " + databaseMetaData.getDriverName() + " " + databaseMetaData.getJDBCMajorVersion() + "." + databaseMetaData.getJDBCMinorVersion() + " running in " + databaseMetaData.getDriverVersion() + " mode");
            Out.info("CacheHandler: Initializing database tables...");
            Statement statement = this.sqlite.createStatement();
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS CacheList (fileid VARCHAR(65)  NOT NULL, lasthit INT UNSIGNED NOT NULL, filesize INT UNSIGNED NOT NULL, active BOOLEAN NOT NULL, PRIMARY KEY(fileid));");
            statement.executeUpdate("CREATE INDEX IF NOT EXISTS Lasthit ON CacheList (lasthit DESC);");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS StringVars ( k VARCHAR(255) NOT NULL, v VARCHAR(255) NOT NULL, PRIMARY KEY(k) );");
            this.cacheIndexClearActive = this.sqlite.prepareStatement("UPDATE CacheList SET active=0;");
            this.cacheIndexCountStats = this.sqlite.prepareStatement("SELECT COUNT(*), SUM(filesize) FROM CacheList;");
            this.queryCachelistSegment = this.sqlite.prepareStatement("SELECT fileid FROM CacheList WHERE fileid BETWEEN ? AND ?;");
            this.queryCachedFileLasthit = this.sqlite.prepareStatement("SELECT lasthit FROM CacheList WHERE fileid=?;");
            this.queryCachedFileSortOnLasthit = this.sqlite.prepareStatement("SELECT fileid, lasthit, filesize FROM CacheList ORDER BY lasthit LIMIT ?, ?;");
            this.insertCachedFile = this.sqlite.prepareStatement("INSERT OR REPLACE INTO CacheList (fileid, lasthit, filesize, active) VALUES (?, ?, ?, 1);");
            this.updateCachedFileActive = this.sqlite.prepareStatement("UPDATE CacheList SET active=1 WHERE fileid=?;");
            this.updateCachedFileLasthit = this.sqlite.prepareStatement("UPDATE CacheList SET lasthit=? WHERE fileid=?;");
            this.deleteCachedFile = this.sqlite.prepareStatement("DELETE FROM CacheList WHERE fileid=?;");
            this.deleteCachedFileInactive = this.sqlite.prepareStatement("DELETE FROM CacheList WHERE active=0;");
            this.setStringVar = this.sqlite.prepareStatement("INSERT OR REPLACE INTO StringVars (k, v) VALUES (?, ?);");
            this.getStringVar = this.sqlite.prepareStatement("SELECT v FROM StringVars WHERE k=?;");
            try {
                statement.executeUpdate("UPDATE CacheIndex SET active=0;");
                Out.info("Updating database schema to r81...");
                object = new Hashtable<String, Long>();
                ResultSet resultSet = statement.executeQuery("SELECT fileid, lasthit FROM CacheIndex;");
                while (resultSet.next()) {
                    ((Hashtable)object).put(resultSet.getString(1), new Long(resultSet.getLong(2)));
                }
                resultSet.close();
                this.sqlite.setAutoCommit(false);
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    this.insertCachedFile.setString(1, string2);
                    this.insertCachedFile.setLong(2, (Long)((Hashtable)object).get(string2));
                    this.insertCachedFile.setInt(3, HVFile.getHVFileFromFileid(string2).getSize());
                    this.insertCachedFile.executeUpdate();
                }
                this.sqlite.setAutoCommit(true);
                statement.executeUpdate("DROP TABLE CacheIndex;");
                Out.info("Database updates complete");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resetFutureLasthits();
            Out.info("CacheHandler: Optimizing database...");
            statement.executeUpdate("VACUUM;");
            if (!Settings.isForceDirty()) {
                this.getStringVar.setString(1, CLEAN_SHUTDOWN_KEY);
                object = this.getStringVar.executeQuery();
                if (object.next()) {
                    this.quickStart = object.getString(1).equals(CLEAN_SHUTDOWN_VALUE);
                }
                object.close();
            }
            this.setStringVar.setString(1, CLEAN_SHUTDOWN_KEY);
            this.setStringVar.setString(2, System.currentTimeMillis() + "");
            this.setStringVar.executeUpdate();
            return true;
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Encountered error reading database.");
            exception.printStackTrace();
            this.terminateDatabase();
            return false;
        }
    }

    private void resetFutureLasthits() throws SQLException {
        Object object;
        long l = (long)Math.floor(System.currentTimeMillis() / 1000L);
        this.sqlite.setAutoCommit(false);
        Out.info("CacheHandler: Checking future lasthits on non-static files...");
        PreparedStatement preparedStatement = this.sqlite.prepareStatement("SELECT fileid FROM CacheList WHERE lasthit>?;");
        preparedStatement.setLong(1, l + 2592000L);
        ResultSet resultSet = preparedStatement.executeQuery();
        List<String> list = Collections.checkedList(new ArrayList(), String.class);
        while (resultSet.next()) {
            object = resultSet.getString(1);
            if (Settings.isStaticRange((String)object)) continue;
            list.add((String)object);
        }
        resultSet.close();
        for (String string : list) {
            this.deleteCachedFile.setString(1, string);
            this.deleteCachedFile.executeUpdate();
            HVFile.getHVFileFromFileid(string).getLocalFileRef().delete();
            Out.debug("Removed old static range file " + string);
        }
        Out.info("CacheHandler: Resetting remaining far-future lasthits...");
        object = this.sqlite.prepareStatement("UPDATE CacheList SET lasthit=? WHERE lasthit>?;");
        object.setLong(1, l + 7776000L);
        object.setLong(2, l + 31536000L);
        object.executeUpdate();
        this.sqlite.setAutoCommit(true);
    }

    public void terminateDatabase() {
        if (this.sqlite != null) {
            try {
                this.setStringVar.setString(1, CLEAN_SHUTDOWN_KEY);
                this.setStringVar.setString(2, CLEAN_SHUTDOWN_VALUE);
                this.setStringVar.executeUpdate();
                this.sqlite.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sqlite = null;
        }
    }

    public void initializeCacheHandler() throws IOException {
        Out.info("CacheHandler: Initializing the cache system...");
        File[] fileArray = tmpdir.listFiles();
        for (File file : fileArray) {
            if (file.isFile()) {
                Out.debug("Deleted orphaned temporary file " + file);
                file.delete();
                continue;
            }
            Out.warning("Found a non-file " + file + " in the temp directory, won't delete.");
        }
        if (this.quickStart && !Settings.isVerifyCache()) {
            try {
                ResultSet resultSet = this.cacheIndexCountStats.executeQuery();
                if (resultSet.next()) {
                    this.cacheCount = resultSet.getInt(1);
                    this.cacheSize = resultSet.getLong(2);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                Out.error("CacheHandler: Failed to perform database operation");
                HentaiAtHomeClient.dieWithError(exception);
            }
            this.updateStats();
            this.flushRecentlyAccessed();
        } else {
            if (Settings.isVerifyCache()) {
                Out.info("CacheHandler: A full cache verification has been requested. This can take quite some time.");
            }
            this.populateInternalCacheTable();
        }
        if (!Settings.isSkipFreeSpaceCheck() && cachedir.getFreeSpace() < Settings.getDiskLimitBytes() - this.cacheSize) {
            this.client.setFastShutdown();
            HentaiAtHomeClient.dieWithError("The storage device does not have enough space available to hold the given cache size.\nFree up space, or reduce the cache size from the H@H settings page.\nhttp://g.e-hentai.org/hentaiathome.php?cid=" + Settings.getClientID());
        }
        if (this.cacheCount < 1 && Settings.getStaticRangeCount() > 20) {
            this.client.setFastShutdown();
            HentaiAtHomeClient.dieWithError("This client has static ranges assigned to it, but the cache is empty.\nCheck permissions and, if necessary, delete the file hath.db in the data directory to rebuild the cache database.\nIf the cache has been deleted or is otherwise lost, you have to manually reset your static ranges from the H@H settings page.\nhttp://g.e-hentai.org/hentaiathome.php?cid=" + Settings.getClientID());
        }
        if (!this.checkAndFreeDiskSpace(cachedir, true)) {
            Out.warning("ClientHandler: There is not enough space left on the disk to add more files to the cache.");
        }
    }

    public HVFile getHVFile(String string, boolean bl) {
        if (HVFile.isValidHVFileid(string)) {
            CachedFile cachedFile = new CachedFile(string);
            if (bl) {
                cachedFile.hit();
            }
            return cachedFile.getHVFile();
        }
        return null;
    }

    public boolean moveFileToCacheDir(File file, HVFile hVFile) {
        if (this.checkAndFreeDiskSpace(file)) {
            File file2 = hVFile.getLocalFileRef();
            try {
                FileTools.checkAndCreateDir(file2.getParentFile());
                if (file.renameTo(file2)) {
                    Out.debug("CacheHandler: Imported file " + file + " to " + hVFile.getFileid());
                    return true;
                }
                if (FileTools.copy(file, file2)) {
                    file.delete();
                    Out.debug("CacheHandler: Imported file " + file + " to " + hVFile.getFileid());
                    return true;
                }
                Out.warning("CacheHandler: Failed to move file " + file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Out.warning("CacheHandler: Encountered exception " + iOException + " when moving file " + file);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToActiveCache(HVFile hVFile) {
        try {
            Connection connection = this.sqlite;
            synchronized (connection) {
                String string = hVFile.getFileid();
                this.updateCachedFileActive.setString(1, string);
                int n = this.updateCachedFileActive.executeUpdate();
                if (n == 0) {
                    long l = (long)Math.floor(System.currentTimeMillis() / 1000L);
                    if (Settings.isStaticRange(string)) {
                        l += 7776000L;
                    }
                    this.insertCachedFile.setString(1, string);
                    this.insertCachedFile.setLong(2, l);
                    this.insertCachedFile.setInt(3, hVFile.getSize());
                    this.insertCachedFile.executeUpdate();
                }
            }
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to perform database operation");
            HentaiAtHomeClient.dieWithError(exception);
        }
        ++this.cacheCount;
        this.cacheSize += (long)hVFile.getSize();
        this.updateStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingRegisterFile(HVFile hVFile) {
        if (hVFile.getSize() <= 0xA00000 && !Settings.isStaticRange(hVFile.getFileid())) {
            ArrayList<HVFile> arrayList = this.pendingRegister;
            synchronized (arrayList) {
                Out.debug("Added " + hVFile + " to pendingRegister");
                this.pendingRegister.add(hVFile);
                if (this.pendingRegister.size() >= 50) {
                    this.client.getServerHandler().notifyRegisterFiles(this.pendingRegister);
                }
            }
        } else {
            Out.debug("Not registering file " + hVFile + " - in static range or larger than 10 MB");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFileFromCache(HVFile hVFile) {
        Connection connection = this.sqlite;
        synchronized (connection) {
            this.deleteFileFromCacheNosync(hVFile);
        }
    }

    private void deleteFileFromCacheNosync(HVFile hVFile) {
        try {
            this.deleteCachedFile.setString(1, hVFile.getFileid());
            this.deleteCachedFile.executeUpdate();
            --this.cacheCount;
            this.cacheSize -= (long)hVFile.getSize();
            hVFile.getLocalFileRef().delete();
            Out.info("CacheHandler: Deleted cached file " + hVFile.getFileid());
            this.updateStats();
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to perform database operation");
            HentaiAtHomeClient.dieWithError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateInternalCacheTable() {
        try {
            this.cacheIndexClearActive.executeUpdate();
            this.cacheCount = 0;
            this.cacheSize = 0L;
            int n = 0;
            int n2 = 0;
            Out.info("CacheHandler: Loading cache.. (this could take a while)");
            Object[] objectArray = cachedir.listFiles();
            Arrays.sort(objectArray);
            try {
                int n3 = 0;
                this.sqlite.setAutoCommit(false);
                for (Object object : objectArray) {
                    if (((File)object).isDirectory()) {
                        Object[] objectArray2 = ((File)object).listFiles();
                        Arrays.sort(objectArray2);
                        for (Object object2 : objectArray2) {
                            boolean bl = false;
                            Object object3 = this.sqlite;
                            synchronized (object3) {
                                this.queryCachedFileLasthit.setString(1, ((File)object2).getName());
                                ResultSet resultSet = this.queryCachedFileLasthit.executeQuery();
                                bl = !resultSet.next();
                                resultSet.close();
                            }
                            object3 = HVFile.getHVFileFromFile((File)object2, Settings.isVerifyCache() || bl);
                            if (object3 != null) {
                                this.addFileToActiveCache((HVFile)object3);
                                if (bl) {
                                    ++n2;
                                    Out.info("CacheHandler: Verified and loaded file " + object2);
                                } else {
                                    ++n;
                                }
                                if (++n3 % 1000 != 0) continue;
                                Out.info("CacheHandler: Loaded " + n3 + " files so far...");
                                continue;
                            }
                            Out.warning("CacheHandler: The file " + object2 + " was corrupt. It is now deleted.");
                            ((File)object2).delete();
                        }
                    } else {
                        ((File)object).delete();
                    }
                    this.flushRecentlyAccessed(false);
                }
                this.sqlite.commit();
                this.sqlite.setAutoCommit(true);
                Connection connection = this.sqlite;
                synchronized (connection) {
                    int n4 = this.deleteCachedFileInactive.executeUpdate();
                    Out.info("CacheHandler: Purged " + n4 + " nonexisting files from database.");
                }
            }
            catch (Exception exception) {
                Out.error("CacheHandler: Failed to perform database operation");
                HentaiAtHomeClient.dieWithError(exception);
            }
            Out.info("CacheHandler: Loaded " + n + " known files.");
            Out.info("CacheHandler: Loaded " + n2 + " new files.");
            Out.info("CacheHandler: Finished initializing the cache (" + this.cacheCount + " files, " + this.cacheSize + " bytes)");
            this.updateStats();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HentaiAtHomeClient.dieWithError("Failed to initialize the cache.");
        }
    }

    public boolean recheckFreeDiskSpace() {
        return this.checkAndFreeDiskSpace(cachedir);
    }

    private boolean checkAndFreeDiskSpace(File file) {
        return this.checkAndFreeDiskSpace(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean checkAndFreeDiskSpace(File file, boolean bl) {
        if (file == null) {
            HentaiAtHomeClient.dieWithError("CacheHandler: checkAndFreeDiskSpace needs a file handle to calculate free space");
        }
        int n = file.isDirectory() ? 0 : (int)file.length();
        long l = Settings.getDiskLimitBytes();
        Out.debug("CacheHandler: Checking disk space (adding " + n + " bytes: cacheSize=" + this.cacheSize + ", cacheLimit=" + l + ", cacheFree=" + (l - this.cacheSize) + ")");
        long l2 = 0L;
        if (this.cacheSize > l) {
            l2 = this.cacheSize - l;
        } else if (this.cacheSize + (long)n - l > 0L) {
            l2 = n * 10;
        }
        if (l2 > 0L) {
            Out.info("CacheHandler: Freeing at least " + l2 + " bytes...");
            List<HVFile> list = Collections.checkedList(new ArrayList(), HVFile.class);
            try {
                while (l2 > 0L && this.cacheCount > 0) {
                    Connection connection = this.sqlite;
                    synchronized (connection) {
                        this.queryCachedFileSortOnLasthit.setInt(1, 0);
                        this.queryCachedFileSortOnLasthit.setInt(2, 20);
                        ResultSet resultSet = this.queryCachedFileSortOnLasthit.executeQuery();
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            HVFile hVFile = HVFile.getHVFileFromFileid(string);
                            if (hVFile == null) continue;
                            this.deleteFileFromCacheNosync(hVFile);
                            l2 -= (long)hVFile.getSize();
                            if (Settings.isStaticRange(string)) continue;
                            list.add(hVFile);
                        }
                        resultSet.close();
                    }
                }
            }
            catch (Exception exception) {
                Out.error("CacheHandler: Failed to perform database operation");
                HentaiAtHomeClient.dieWithError(exception);
            }
            if (!bl) {
                this.client.getServerHandler().notifyUncachedFiles(list);
            }
        }
        if (Settings.isSkipFreeSpaceCheck()) {
            Out.debug("CacheHandler: Disk free space check is disabled.");
            return true;
        }
        long l3 = file.getFreeSpace();
        if (l3 < Math.max(Settings.getDiskMinRemainingBytes(), 0x6400000L)) {
            Out.warning("CacheHandler: Cannot meet space constraints: Disk free space limit reached (" + l3 + " bytes free on device)");
            return false;
        }
        Out.debug("CacheHandler: Disk space constraints met (" + l3 + " bytes free on device)");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pruneOldFiles() {
        List<HVFile> list = Collections.checkedList(new ArrayList(), HVFile.class);
        int n = 0;
        Out.info("Checking for old files to prune...");
        try {
            Connection connection = this.sqlite;
            synchronized (connection) {
                this.queryCachedFileSortOnLasthit.setInt(1, 0);
                this.queryCachedFileSortOnLasthit.setInt(2, 20);
                ResultSet resultSet = this.queryCachedFileSortOnLasthit.executeQuery();
                long l = (long)Math.floor(System.currentTimeMillis() / 1000L);
                while (resultSet.next()) {
                    HVFile hVFile;
                    String string = resultSet.getString(1);
                    long l2 = resultSet.getInt(2);
                    if (l2 >= l - 2592000L || (hVFile = HVFile.getHVFileFromFileid(string)) == null) continue;
                    this.deleteFileFromCacheNosync(hVFile);
                    ++n;
                    if (Settings.isStaticRange(string)) continue;
                    list.add(hVFile);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to perform database operation");
            HentaiAtHomeClient.dieWithError(exception);
        }
        this.client.getServerHandler().notifyUncachedFiles(list);
        Out.info("Pruned " + n + " files.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processBlacklist(long l, boolean bl) {
        Out.info("CacheHandler: Retrieving list of blacklisted files...");
        String[] stringArray = this.client.getServerHandler().getBlacklist(l);
        if (stringArray == null) {
            Out.warning("CacheHandler: Failed to retrieve file blacklist, will try again later.");
            return;
        }
        Out.info("CacheHandler: Looking for and deleting blacklisted files...");
        int n = 0;
        List<HVFile> list = Collections.checkedList(new ArrayList(), HVFile.class);
        try {
            Connection connection = this.sqlite;
            synchronized (connection) {
                for (String string : stringArray) {
                    this.queryCachedFileLasthit.setString(1, string);
                    ResultSet resultSet = this.queryCachedFileLasthit.executeQuery();
                    HVFile hVFile = null;
                    if (resultSet.next()) {
                        hVFile = HVFile.getHVFileFromFileid(string);
                    }
                    resultSet.close();
                    if (hVFile == null) continue;
                    ++n;
                    this.deleteFileFromCacheNosync(hVFile);
                    if (Settings.isStaticRange(hVFile.getFileid())) continue;
                    list.add(hVFile);
                }
            }
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to perform database operation");
            HentaiAtHomeClient.dieWithError(exception);
        }
        if (!bl) {
            this.client.getServerHandler().notifyUncachedFiles(list);
        }
        Out.info("CacheHandler: " + n + " blacklisted files were removed.");
    }

    private void updateStats() {
        Stats.setCacheCount(this.cacheCount);
        Stats.setCacheSize(this.cacheSize);
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public int getSegmentCount() {
        return Settings.isUseLessMemory() && this.cacheCount > 16000 || this.cacheCount > 400000 ? 256 : 16;
    }

    public int getStartupCachedFilesStrlen() {
        return this.startupCachedFileStrlen;
    }

    public void calculateStartupCachedFilesStrlen() {
        int n = this.getSegmentCount();
        this.startupCachedFileStrlen = 0;
        for (int i = 0; i < n; ++i) {
            LinkedList<String> linkedList = this.getCachedFilesSegment(Integer.toHexString(n | i).substring(1));
            for (String string : linkedList) {
                this.startupCachedFileStrlen += string.length() + 1;
            }
            Out.info("Calculated segment " + i + " of " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<String> getCachedFilesSegment(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            System.gc();
            Connection connection = this.sqlite;
            synchronized (connection) {
                this.queryCachelistSegment.setString(1, string + "0");
                this.queryCachelistSegment.setString(2, string + "g");
                ResultSet resultSet = this.queryCachelistSegment.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    if (Settings.isStaticRange(string2)) continue;
                    linkedList.add(string2);
                }
                resultSet.close();
            }
            System.gc();
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to perform database operation");
            HentaiAtHomeClient.dieWithError(exception);
        }
        return linkedList;
    }

    public static File getCacheDir() {
        return cachedir;
    }

    public static File getTmpDir() {
        return tmpdir;
    }

    public void flushRecentlyAccessed() {
        this.flushRecentlyAccessed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushRecentlyAccessed(boolean bl) {
        ArrayList<CachedFile> arrayList;
        ArrayList<CachedFile> arrayList2 = null;
        if (this.memoryWrittenTable != null) {
            int n = Math.min(0x100000, this.memoryClearPointer + 121);
            while (this.memoryClearPointer < n) {
                this.memoryWrittenTable[this.memoryClearPointer++] = 0;
            }
            if (n >= 0x100000) {
                this.memoryClearPointer = 0;
            }
        }
        Object object = this.recentlyAccessed;
        synchronized (object) {
            this.recentlyAccessedFlush = System.currentTimeMillis();
            arrayList = new ArrayList<CachedFile>(this.recentlyAccessed.size());
            arrayList.addAll(this.recentlyAccessed);
            this.recentlyAccessed.clear();
        }
        if (arrayList.size() > 0) {
            try {
                object = this.sqlite;
                synchronized (object) {
                    String string;
                    arrayList2 = new ArrayList<CachedFile>(arrayList.size());
                    for (CachedFile cachedFile : arrayList) {
                        string = cachedFile.getFileid();
                        boolean bl2 = true;
                        if (this.memoryWrittenTable != null) {
                            bl2 = false;
                            try {
                                int n;
                                int n2 = 0;
                                for (n = 0; n < 5; ++n) {
                                    n2 += Integer.parseInt(string.substring(n, n + 1), 16) << (4 - n) * 4;
                                }
                                n = (short)(1 << Short.parseShort(string.substring(5, 6), 16));
                                if ((this.memoryWrittenTable[n2] & n) == 0) {
                                    int n3 = n2;
                                    this.memoryWrittenTable[n3] = (short)(this.memoryWrittenTable[n3] | n);
                                    bl2 = true;
                                }
                            }
                            catch (Exception exception) {
                                Out.warning("Encountered invalid fileid " + string + " while checking memoryWrittenTable.");
                            }
                        }
                        if (!bl2) continue;
                        this.queryCachedFileLasthit.setString(1, string);
                        ResultSet resultSet = this.queryCachedFileLasthit.executeQuery();
                        if (resultSet.next()) {
                            long l = resultSet.getLong(1);
                            long l2 = (long)Math.floor(System.currentTimeMillis() / 1000L);
                            if (Settings.isStaticRange(string)) {
                                if (l > l2 + 28944000L) {
                                    bl2 = false;
                                }
                            } else if (l > l2 - 86400L) {
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            arrayList2.add(cachedFile);
                        }
                        resultSet.close();
                    }
                    if (arrayList2.size() > 0) {
                        if (bl) {
                            this.sqlite.setAutoCommit(false);
                        }
                        for (CachedFile cachedFile : arrayList2) {
                            if (!cachedFile.needsFlush()) continue;
                            string = cachedFile.getFileid();
                            long l = (long)Math.floor(System.currentTimeMillis() / 1000L);
                            if (Settings.isStaticRange(string)) {
                                l += 31536000L;
                            }
                            this.updateCachedFileLasthit.setLong(1, l);
                            this.updateCachedFileLasthit.setString(2, string);
                            this.updateCachedFileLasthit.executeUpdate();
                            cachedFile.flushed();
                        }
                        if (bl) {
                            this.sqlite.setAutoCommit(true);
                        }
                    }
                }
            }
            catch (Exception exception) {
                Out.error("CacheHandler: Failed to perform database operation");
                HentaiAtHomeClient.dieWithError(exception);
            }
        }
    }

    private class CachedFile {
        private String fileid;
        private boolean needFlush;

        public CachedFile(String string) {
            this.fileid = string;
            this.needFlush = false;
        }

        public String getFileid() {
            return this.fileid;
        }

        public HVFile getHVFile() {
            return HVFile.getHVFileFromFileid(this.fileid);
        }

        public boolean needsFlush() {
            return this.needFlush;
        }

        public void flushed() {
            this.needFlush = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hit() {
            ArrayList<CachedFile> arrayList = CacheHandler.this.recentlyAccessed;
            synchronized (arrayList) {
                this.needFlush = true;
                CacheHandler.this.recentlyAccessed.add(this);
            }
        }
    }
}

