/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.hath.base.FileTools;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class FileDownloader
implements Runnable {
    private int timeout = 30000;
    private int maxDLTime = Integer.MAX_VALUE;
    private int retries = 3;
    private long timeDownloadStart = 0L;
    private long timeFirstByte = 0L;
    private long timeDownloadFinish = 0L;
    private byte[] bytearray = null;
    private URL source;
    private Thread myThread;
    private Object downloadLock = new Object();
    private boolean started = false;

    public FileDownloader(URL uRL) {
        this.source = uRL;
    }

    public FileDownloader(URL uRL, int n) {
        this.source = uRL;
        this.timeout = n;
    }

    public FileDownloader(URL uRL, int n, int n2) {
        this.source = uRL;
        this.timeout = n;
        this.maxDLTime = n2;
    }

    public boolean saveFile(File file) {
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            FileTools.checkAndCreateDir(file.getParentFile());
            if (this.downloadFile()) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.bytearray, 0, this.bytearray.length);
                fileOutputStream.close();
                return true;
            }
        }
        catch (Exception exception) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof IOException && exception.getMessage().equals("There is not enough space on the disk")) {
                Out.warning("Error: No space on disk");
            }
            Out.warning(exception + " while saving file " + this.source + " to " + file.getAbsolutePath());
            exception.printStackTrace();
        }
        return false;
    }

    public String getTextContent() {
        if (this.downloadFile()) {
            return new String(this.bytearray, 0, this.bytearray.length);
        }
        return null;
    }

    private boolean downloadFile() {
        if (this.myThread == null) {
            this.run();
        } else {
            this.waitAsyncDownload();
        }
        return this.timeDownloadFinish > 0L;
    }

    public void startAsyncDownload() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitAsyncDownload() {
        Object object = this.downloadLock;
        synchronized (object) {
        }
        return this.timeDownloadFinish > 0L;
    }

    public long getDownloadTimeMillis() {
        return this.timeFirstByte > 0L ? this.timeDownloadFinish - this.timeFirstByte : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.downloadLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            while (this.retries-- > 0) {
                InputStream inputStream = null;
                BufferedInputStream bufferedInputStream = null;
                try {
                    Out.info("Connecting to " + this.source.getHost() + "...");
                    URLConnection uRLConnection = Settings.getUseProxy() ? this.source.openConnection(Settings.getProxy()) : this.source.openConnection();
                    uRLConnection.setConnectTimeout(10000);
                    uRLConnection.setReadTimeout(this.timeout);
                    uRLConnection.setRequestProperty("Connection", "Close");
                    uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.12) Gecko/20080201 Firefox/2.0.0.12");
                    uRLConnection.connect();
                    Out.debug("Connected to " + this.source);
                    int n = uRLConnection.getContentLength();
                    if (n < 0) {
                        Out.warning("Remote host did not send Content-Length, aborting transfer.");
                        return;
                    }
                    if (n > 0xA00000) {
                        Out.warning("Reported contentLength " + n + " on request " + this.source + " is out of bounds!");
                        return;
                    }
                    Out.debug("Received contentLength=" + n);
                    this.bytearray = new byte[n];
                    inputStream = uRLConnection.getInputStream();
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    Out.info(this.source.getPath() + (this.source.getQuery() != null ? "?" + this.source.getQuery() : "") + ": Retrieving " + n + " bytes...");
                    this.timeDownloadStart = System.currentTimeMillis();
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 < n) {
                        int n4 = bufferedInputStream.available();
                        if (n4 > 0) {
                            if (this.timeFirstByte == 0L) {
                                this.timeFirstByte = System.currentTimeMillis();
                            }
                            n3 = 0;
                            int n5 = bufferedInputStream.read(this.bytearray, n2, n4);
                            if (n5 >= 0) {
                                n2 += n5;
                                continue;
                            }
                            Out.warning("\nServer sent premature EOF, aborting.. (" + n2 + " of " + n + " bytes received)");
                            throw new SocketException("Unexpected end of file from server");
                        }
                        if (System.currentTimeMillis() - this.timeDownloadStart > (long)this.maxDLTime) {
                            Out.warning("\nDownload time limit has expired, aborting...");
                            throw new SocketTimeoutException("Download timed out");
                        }
                        if (n3 > this.timeout) {
                            Out.warning("\nTimeout detected waiting for byte " + n2 + ", aborting..");
                            throw new SocketTimeoutException("Read timed out");
                        }
                        n3 += 5;
                        Thread.currentThread();
                        Thread.sleep(5L);
                    }
                    Out.debug("Finished. bytecounter=" + n2);
                    bufferedInputStream.close();
                    inputStream.close();
                    Stats.bytesRcvd(n);
                    this.timeDownloadFinish = System.currentTimeMillis();
                    return;
                }
                catch (Exception exception) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    String string = exception.getMessage();
                    Throwable throwable = exception.getCause();
                    String string2 = null;
                    if (throwable != null) {
                        String string3 = string2 = throwable.getMessage() != null ? throwable.getMessage() : "";
                    }
                    if (string != null) {
                        if (string.equals("Connection timed out: connect")) {
                            Out.warning("Connection timed out getting " + this.source + ", retrying.. (" + this.retries + " tries left)");
                            continue;
                        }
                        if (string.equals("Connection refused: connect")) {
                            Out.warning("Connection refused getting " + this.source + ", retrying.. (" + this.retries + " tries left)");
                            continue;
                        }
                        if (string.equals("Unexpected end of file from server")) {
                            Out.warning("Connection prematurely reset getting " + this.source + ", retrying.. (" + this.retries + " tries left)");
                            continue;
                        }
                        if (exception instanceof FileNotFoundException) {
                            Out.warning("Server returned: 404 Not Found");
                            break;
                        }
                        if (string.indexOf("403 for URL") >= 0) {
                            Out.warning("Server returned: 403 Forbidden");
                            break;
                        }
                        if (exception instanceof SocketException && string.equals("Connection reset")) {
                            Out.warning("Connection reset getting " + this.source + ", retrying.. (" + this.retries + " tries left)");
                            continue;
                        }
                        if (exception instanceof UnknownHostException) {
                            Out.warning("Unknown host " + this.source.getHost() + ", aborting..");
                            break;
                        }
                        if (exception instanceof SocketTimeoutException) {
                            Out.warning("Read timed out, retrying.. (" + this.retries + " tries left)");
                            continue;
                        }
                        Out.warning("Unhandled exception: " + exception.toString());
                        exception.printStackTrace();
                        Out.warning("Retrying.. (" + this.retries + " tries left)");
                        continue;
                    }
                    if (throwable != null) {
                        if (throwable instanceof FileNotFoundException) {
                            Out.warning("Server returned: 404 Not Found");
                            break;
                        }
                        if (string2.indexOf("403 for URL") >= 0) {
                            Out.warning("Server returned: 403 Forbidden");
                            break;
                        }
                        if (string2.equals("Unexpected end of file from server")) {
                            Out.warning("Connection prematurely reset getting " + this.source + ", retrying.. (" + this.retries + " tries left)");
                            continue;
                        }
                        Out.warning("Unhandled exception/cause: " + exception.toString());
                        exception.printStackTrace();
                        Out.warning("Retrying.. (" + this.retries + " tries left)");
                        continue;
                    }
                    Out.warning("Exception with no exception message nor cause:");
                    exception.printStackTrace();
                    Out.warning("Retrying.. (" + this.retries + " tries left)");
                }
            }
        }
        Out.warning("Exhaused retries or aborted getting " + this.source);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Need source and destination.");
        } else {
            try {
                URL uRL = new URL(stringArray[0]);
                File file = new File(stringArray[1]);
                System.out.println("Downloading file " + uRL);
                FileDownloader fileDownloader = new FileDownloader(uRL);
                fileDownloader.saveFile(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

