/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileTools {
    public static File checkAndCreateDir(File file) throws IOException {
        if (file.isFile()) {
            file.delete();
        }
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    public static byte[] getFileContents(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    public static String getStringFileContents(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        return new String(cArray);
    }

    public static String getStringFileContentsUTF8(File file) throws IOException {
        int n = (int)file.length();
        char[] cArray = new char[n];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        bufferedReader.read(cArray, 0, n);
        bufferedReader.close();
        return new String(cArray);
    }

    public static void putFileContents(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static void putStringFileContents(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    public static void putStringFileContentsUTF8(File file, String string) throws IOException {
        int n = string.length();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        bufferedWriter.write(string, 0, n);
        bufferedWriter.close();
    }

    public static String getFileExtension(File file) {
        String[] stringArray = file.getName().split("(-|\\.)");
        if (stringArray.length > 1) {
            return stringArray[stringArray.length - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File file, File file2) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            bl = true;
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }
}

