/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.hath.base.FileTools;
import org.hath.base.Gallery;
import org.hath.base.GalleryFile;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.Out;
import org.hath.base.Settings;

public class GalleryDownloadManager
implements Runnable {
    protected HentaiAtHomeClient client;
    private Thread myThread;
    private File hhdldir;
    private File downloadeddir;
    private List<File> processedHHDLFiles;
    private List<Gallery> pendingGalleries;
    private long lastTokenRequest;

    public GalleryDownloadManager(HentaiAtHomeClient hentaiAtHomeClient) {
        this.client = hentaiAtHomeClient;
        this.processedHHDLFiles = new ArrayList<File>();
        this.pendingGalleries = new ArrayList<Gallery>();
        this.lastTokenRequest = System.currentTimeMillis() + 3600060L;
        try {
            this.hhdldir = FileTools.checkAndCreateDir(new File("hathdl"));
            this.downloadeddir = FileTools.checkAndCreateDir(new File("downloaded"));
        }
        catch (IOException iOException) {
            HentaiAtHomeClient.dieWithError(iOException);
        }
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (!this.client.isShuttingDown()) {
            long l = 10000L;
            if (this.client.isSuspended()) {
                this.lastTokenRequest = System.currentTimeMillis() + 960000L;
                l = 60000L;
            } else {
                Object object;
                ArrayList<File> arrayList = new ArrayList<File>();
                File[] fileArray = this.hhdldir.listFiles();
                for (File file : fileArray) {
                    if (!file.isFile() || !file.getName().endsWith(".hathdl")) continue;
                    arrayList.add(file);
                }
                try {
                    for (File file : arrayList) {
                        void var9_19;
                        void var10_27;
                        String[] stringArray;
                        if (this.processedHHDLFiles.contains(file)) continue;
                        Out.debug("Downloader: Started HathDL processing from " + file);
                        int n = 0;
                        int n2 = 0;
                        Object var9_18 = null;
                        String string = "";
                        GalleryFile[] galleryFileArray = null;
                        object = null;
                        int n3 = 0;
                        for (String string2 : stringArray = FileTools.getStringFileContentsUTF8(file).split("\n")) {
                            String[] stringArray2;
                            if (string2.equals("FILELIST") && n3 == 0) {
                                n3 = 1;
                                continue;
                            }
                            if (string2.equals("INFORMATION") && n3 == 1) {
                                n3 = 2;
                                continue;
                            }
                            if (n3 == 0) {
                                if (string2.isEmpty()) continue;
                                stringArray2 = string2.split(" ", 2);
                                if (stringArray2[0].equals("GID")) {
                                    n = Integer.parseInt(stringArray2[1]);
                                    continue;
                                }
                                if (stringArray2[0].equals("FILES")) {
                                    n2 = Integer.parseInt(stringArray2[1]);
                                    galleryFileArray = new GalleryFile[n2];
                                    continue;
                                }
                                if (!stringArray2[0].equals("TITLE")) continue;
                                String string3 = stringArray2[1].replaceAll("(\\*|\\\"|\\\\|<|>|:\\|\\?)", "").replaceAll("\\s+", " ").replaceAll("(^\\s+|\\s+$)", "");
                                object = string3.length() > 100 ? new File(this.downloadeddir, string3.substring(0, 97) + "... [" + n + "]") : new File(this.downloadeddir, string3 + " [" + n + "]");
                                if (!((File)object).getParentFile().equals(this.downloadeddir)) {
                                    Out.warning("Downloader: Security Error - HHDL target download directory isn't where it's supposed to be. Aborted HHDL.");
                                    n = 0;
                                    break;
                                }
                                Out.debug("Downloader: Created directory " + object);
                                FileTools.checkAndCreateDir((File)object);
                                continue;
                            }
                            if (n3 == 1) {
                                int n4;
                                GalleryFile galleryFile;
                                if (string2.isEmpty() || (galleryFile = GalleryFile.getGalleryFile(this.client, (File)object, (stringArray2 = string2.split(" ", 3))[1], n, n4 = Integer.parseInt(stringArray2[0]), stringArray2[2])) == null) continue;
                                if (n4 >= 1 && n4 <= n2) {
                                    galleryFileArray[n4 - 1] = galleryFile;
                                    continue;
                                }
                                Out.warning("File " + galleryFile.getFileid() + " is outside allowed page range.");
                                continue;
                            }
                            String string4 = var10_27.concat(string2).concat(Settings.NEWLINE);
                        }
                        if (n <= 0 || n2 <= 0 || var9_19 == null || galleryFileArray == null) continue;
                        this.pendingGalleries.add(new Gallery(this.client, file, (File)object, (String)var9_19, (String)var10_27, galleryFileArray));
                        this.processedHHDLFiles.add(file);
                    }
                }
                catch (IOException iOException) {
                    Out.warning("Downloader: Encountered I/O error while processing HHDL files.");
                    iOException.printStackTrace();
                }
                if (!this.pendingGalleries.isEmpty()) {
                    long l2;
                    boolean bl = true;
                    if (!Settings.isSkipFreeSpaceCheck() && (l2 = this.downloadeddir.getFreeSpace()) < Math.max(Settings.getDiskMinRemainingBytes(), 0x6400000L)) {
                        Out.warning("Downloader: There is less than the minimum allowed space left on the storage device. The Hentai@Home Downloader is waiting for more disk space before it can continue.");
                        l = 300000L;
                        bl = false;
                    }
                    if (bl) {
                        ArrayList<GalleryFile> arrayList2 = new ArrayList<GalleryFile>();
                        ArrayList<Gallery> arrayList3 = new ArrayList<Gallery>();
                        for (Gallery gallery : this.pendingGalleries) {
                            if (this.client.isShuttingDown()) break;
                            gallery.galleryPass(arrayList2);
                            if (gallery.getState() == 0) continue;
                            arrayList3.add(gallery);
                        }
                        for (Gallery gallery : arrayList3) {
                            this.pendingGalleries.remove(gallery);
                        }
                        if (!arrayList2.isEmpty() && this.lastTokenRequest < System.currentTimeMillis() - 60000L) {
                            ArrayList arrayList4 = new ArrayList();
                            for (GalleryFile galleryFile : arrayList2) {
                                arrayList4.add(galleryFile.getFileid());
                            }
                            this.lastTokenRequest = System.currentTimeMillis();
                            Hashtable<String, String> hashtable = this.client.getServerHandler().getFileTokens(arrayList4);
                            if (hashtable == null) {
                                l = 180000L;
                            } else {
                                for (GalleryFile[] galleryFileArray : arrayList2) {
                                    object = hashtable.get(galleryFileArray.getFileid());
                                    if (object == null) continue;
                                    galleryFileArray.setNewToken((String)object);
                                }
                            }
                        }
                    }
                }
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        Out.info("Gallery Download Manager terminated.");
    }
}

