/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.IOException;
import org.hath.base.FileTools;
import org.hath.base.GalleryFileDownloader;
import org.hath.base.HVFile;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.Out;

public class GalleryFile {
    private HentaiAtHomeClient client;
    public static final int FILE_SUCCESS = 1;
    public static final int FILE_TEMPFAIL = -1;
    public static final int FILE_PERMFAIL = -2;
    public static final int FILE_INVALID_TOKEN = -3;
    public static final int STATE_PROCESSED_ERRORS = -1;
    public static final int STATE_PENDING = 0;
    public static final int STATE_PROCESSED = 1;
    private File todir;
    private File tofile;
    private HVFile hvfile;
    private String fileid;
    private String filename;
    private String token;
    private int gid;
    private int page;
    private long tokentime;
    private int state;
    private int retrycount;
    private long lastretry;

    private GalleryFile(HentaiAtHomeClient hentaiAtHomeClient, File file, String string, int n, int n2, String string2) {
        this.hvfile = HVFile.getHVFileFromFileid(string);
        this.client = hentaiAtHomeClient;
        this.todir = file;
        this.fileid = string;
        this.gid = n;
        this.page = n2;
        int n3 = string2.lastIndexOf(".");
        this.filename = string2.substring(0, Math.min(80, n3 > -1 ? n3 : string2.length())) + "." + this.hvfile.getType();
        this.tofile = new File(file, this.filename);
        this.state = 0;
        this.retrycount = 0;
        this.lastretry = 0L;
        Out.debug("Downloader: Pending download for " + string + " => " + this.filename);
    }

    public static GalleryFile getGalleryFile(HentaiAtHomeClient hentaiAtHomeClient, File file, String string, int n, int n2, String string2) {
        if (hentaiAtHomeClient != null && file != null && string != null && n > 0 && n2 > 0 && string2 != null && HVFile.isValidHVFileid(string) && string2.length() > 0) {
            return new GalleryFile(hentaiAtHomeClient, file, string, n, n2, string2);
        }
        Out.warning("Invalid GalleryFile " + string + " (" + string2 + ")");
        return null;
    }

    public void setNewToken(String string) {
        this.token = string;
        this.tokentime = System.currentTimeMillis();
    }

    public int getState() {
        return this.state;
    }

    public String getFileid() {
        return this.fileid;
    }

    public int attemptDownload() {
        if (System.currentTimeMillis() < this.lastretry + (long)(360000 * this.retrycount)) {
            return -1;
        }
        if (!this.tofile.getParentFile().equals(this.todir)) {
            this.state = -1;
            return -2;
        }
        if (this.tofile.isFile()) {
            Out.debug("Downloader: " + this.tofile + " already exists - marking as completed");
            this.state = 1;
            return 1;
        }
        boolean bl = this.tokentime > System.currentTimeMillis() - 3600000L;
        File file = this.hvfile.getLocalFileRef();
        if (bl && !file.isFile()) {
            Out.debug("Downloader: " + this.tofile + " - initializing GalleryFileDownloader");
            GalleryFileDownloader galleryFileDownloader = new GalleryFileDownloader(this.client, this.fileid, this.token, this.gid, this.page, this.filename, this.retrycount > 3);
            galleryFileDownloader.initialize();
            int n = 1000;
            int n2 = 0;
            do {
                try {
                    Thread.currentThread();
                    Thread.sleep(n);
                    n2 += n;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (galleryFileDownloader.getDownloadState() == 0 && n2 < 300000);
        }
        if (file.isFile()) {
            FileTools.copy(file, this.tofile);
            Out.debug("Downloader: " + file + " copied to " + this.tofile);
            this.state = 1;
            return 1;
        }
        if (!bl) {
            return -3;
        }
        this.lastretry = System.currentTimeMillis();
        if (++this.retrycount > 100) {
            try {
                new File(this.todir, this.filename + ".fail").createNewFile();
                Out.debug("Downloader: Permanently failing download of " + this.fileid);
            }
            catch (IOException iOException) {
                Out.warning("Downloader: Failed to create empty .fail file");
                iOException.printStackTrace();
            }
            this.state = -1;
            return -2;
        }
        return -1;
    }
}

