/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import org.hath.base.CacheHandler;
import org.hath.base.FileTools;
import org.hath.base.HVFile;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.MiscTools;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class GalleryFileDownloader
implements Runnable {
    public static final int DOWNLOAD_PENDING = 0;
    public static final int DOWNLOAD_COMPLETE = 1;
    public static final int DOWNLOAD_FAILED_INIT = -1;
    public static final int DOWNLOAD_FAILED_CONN = -2;
    private HentaiAtHomeClient client;
    private HVFile requestedHVFile;
    private String fileid;
    private String token;
    private int gid;
    private int page;
    private String filename;
    private boolean skipHath;
    private byte[] databuffer;
    private int writeoff;
    private int contentLength;
    private Thread myThread;
    private URLConnection connection;
    private int downloadState;

    public GalleryFileDownloader(HentaiAtHomeClient hentaiAtHomeClient, String string, String string2, int n, int n2, String string3, boolean bl) {
        this.client = hentaiAtHomeClient;
        this.fileid = string;
        this.token = string2;
        this.gid = n;
        this.page = n2;
        this.filename = string3;
        this.skipHath = bl;
        this.requestedHVFile = HVFile.getHVFileFromFileid(string);
        this.writeoff = 0;
        this.downloadState = 0;
        this.myThread = new Thread(this);
    }

    public int initialize() {
        Out.info("Gallery File Download Request initializing for " + this.fileid + "...");
        try {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            do {
                bl = false;
                URL uRL = new URL("http", Settings.getRequestServer(), "/r/" + this.fileid + "/" + this.token + "/" + this.gid + "-" + this.page + "/" + this.filename + (this.skipHath ? "?nl=1" : ""));
                Out.debug("GalleryFileDownloader: Requesting file download from " + uRL);
                URLConnection uRLConnection = Settings.getUseProxy() ? uRL.openConnection(Settings.getProxy()) : uRL.openConnection();
                uRLConnection.setConnectTimeout(10000);
                uRLConnection.setReadTimeout(30000);
                uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.12) Gecko/20080201 Firefox/2.0.0.12");
                uRLConnection.setRequestProperty("Hath-Request", Settings.getClientID() + "-" + MiscTools.getSHAString(Settings.getClientKey() + this.fileid));
                uRLConnection.connect();
                n2 = uRLConnection.getContentLength();
                if (n2 < 0) {
                    Out.warning("Request host did not send Content-Length, aborting transfer. (" + uRLConnection + ")");
                    Out.warning("Note: A common reason for this is running firewalls with outgoing restrictions or programs like PeerGuardian/PeerBlock. Verify that the remote host is not blocked.");
                    n = 502;
                    continue;
                }
                if (n2 > 0xA00000) {
                    Out.warning("Content-Length is larger than 10 MB, aborting transfer. (" + uRLConnection + ")");
                    n = 502;
                    continue;
                }
                if (n2 != this.requestedHVFile.getSize()) {
                    Out.warning("Reported contentLength " + this.contentLength + " does not match expected length of file " + this.fileid + " (" + uRLConnection + ")");
                    if (n != 0 || n2 != 28658 && n2 != 1009) continue;
                    Out.warning("We appear to have reached the image limit. Attempting to contact the server to ask for a limit increase...");
                    this.client.getServerHandler().notifyMoreFiles();
                    bl = true;
                    n = 502;
                    continue;
                }
                n = 0;
            } while (bl);
            if (n > 0) {
                this.downloadState = -1;
                return n;
            }
            this.contentLength = n2;
            this.databuffer = new byte[this.contentLength];
            this.myThread.start();
            return 200;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.downloadState = -1;
            return 500;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        int n = 3;
        boolean bl = false;
        boolean bl2 = false;
        do {
            object2 = null;
            object = null;
            try {
                object2 = this.connection.getInputStream();
                object = new BufferedInputStream((InputStream)object2);
                long l = System.currentTimeMillis();
                int n2 = 0;
                int n3 = 0;
                while (this.writeoff < this.contentLength) {
                    if (((BufferedInputStream)object).available() > 0) {
                        n2 = 0;
                        int n4 = ((BufferedInputStream)object).read();
                        if (n4 >= 0) {
                            this.databuffer[this.writeoff++] = (byte)n4;
                            if (++n3 <= 1000) continue;
                            Stats.bytesRcvd(n3);
                            n3 -= 1000;
                            continue;
                        }
                        Out.warning("\nServer sent premature EOF, aborting.. (" + this.writeoff + " of " + this.contentLength + " bytes received)");
                        throw new SocketException("Unexpected end of file from server");
                    }
                    if (System.currentTimeMillis() - l > 300000L) {
                        Out.warning("\nDownload time limit has expired, aborting...");
                        throw new SocketTimeoutException("Download timed out");
                    }
                    if (n2 > 30000) {
                        Out.warning("\nTimeout detected waiting for byte " + this.writeoff + ", aborting..");
                        throw new SocketTimeoutException("Read timed out");
                    }
                    n2 += 5;
                    Thread.currentThread();
                    Thread.sleep(5L);
                }
                Stats.bytesRcvd(n3);
                Stats.fileRcvd();
                bl = true;
            }
            catch (Exception exception) {
                this.writeoff = 0;
                Arrays.fill(this.databuffer, (byte)0);
                Out.debug("Retrying.. (" + n + " tries left)");
            }
            finally {
                try {
                    ((BufferedInputStream)object).close();
                }
                catch (Exception exception) {}
                try {
                    ((InputStream)object2).close();
                }
                catch (Exception exception) {}
            }
        } while (!bl && --n > 0);
        if (this.writeoff != this.getContentLength()) {
            Out.debug("Requested file " + this.fileid + " is incomplete, and was not stored.");
        } else if (!MiscTools.getSHAString(this.databuffer).equals(this.requestedHVFile.getHash())) {
            Out.debug("Requested file " + this.fileid + " is corrupt, and was not stored.");
        } else {
            try {
                object2 = this.client.getCacheHandler();
                object = File.createTempFile("hathproxy_", "", CacheHandler.getTmpDir());
                FileTools.putFileContents((File)object, this.databuffer);
                if (((CacheHandler)object2).moveFileToCacheDir((File)object, this.requestedHVFile)) {
                    ((CacheHandler)object2).addFileToActiveCache(this.requestedHVFile);
                    ((CacheHandler)object2).addPendingRegisterFile(this.requestedHVFile);
                    Out.debug("Requested file " + this.fileid + " was successfully stored in cache.");
                    bl2 = true;
                } else {
                    ((File)object).delete();
                    Out.debug("Requested file " + this.fileid + " exists or cannot be cached, and was dropped.");
                }
                Out.info("Gallery File Download Request complete for " + this.fileid);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.downloadState = bl2 ? 1 : -2;
    }

    public String getContentType() {
        return this.requestedHVFile.getMimeType();
    }

    public int getContentLength() {
        return this.requestedHVFile.getSize();
    }

    public int getCurrentWriteoff() {
        return this.writeoff;
    }

    public int getDownloadState() {
        return this.downloadState;
    }

    public byte[] getDownloadBufferRange(int n, int n2) {
        return Arrays.copyOfRange(this.databuffer, n, n2);
    }
}

