/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import org.hath.base.Settings;

public class HTTPBandwidthMonitor {
    private int sleepTrigger = 0;

    private double getMinMillisPerPacket() {
        return Settings.getThrottleBytesPerSec() > 0 ? 1000.0 * (double)this.getActualPacketSize() / (double)Settings.getThrottleBytesPerSec() : 0.0;
    }

    public synchronized void synchronizedWait(Thread thread) {
        long l = Math.round(this.getMinMillisPerPacket() * (double)(++this.sleepTrigger) + (Math.random() - 0.5));
        if (l > 2L) {
            this.sleepTrigger = 0;
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getActualPacketSize() {
        if (Settings.getThrottleBytesPerSec() == 0 || Settings.getThrottleBytesPerSec() >= 15000) {
            return 1460;
        }
        return 536;
    }
}

