/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.hath.base.HTTPResponseProcessor;
import org.hath.base.HTTPResponseProcessorCachelist;
import org.hath.base.HTTPResponseProcessorFile;
import org.hath.base.HTTPResponseProcessorProxy;
import org.hath.base.HTTPResponseProcessorSpeedtest;
import org.hath.base.HTTPResponseProcessorText;
import org.hath.base.HTTPSession;
import org.hath.base.HVFile;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.MiscTools;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class HTTPResponse {
    private static final Pattern absoluteUriPattern = Pattern.compile("^http://[^/]+/", 2);
    private HTTPSession session;
    private boolean requestHeadOnly;
    private boolean validRequest;
    private boolean servercmd;
    private int responseStatusCode;
    private HTTPResponseProcessor hpc;

    public HTTPResponse(HTTPSession hTTPSession) {
        this.session = hTTPSession;
        this.validRequest = false;
        this.servercmd = false;
        this.requestHeadOnly = false;
        this.responseStatusCode = 500;
    }

    private HTTPResponseProcessor processRemoteAPICommand(String string, String string2) {
        Hashtable<String, String> hashtable = MiscTools.parseAdditional(string2);
        HentaiAtHomeClient hentaiAtHomeClient = this.session.getHTTPServer().getHentaiAtHomeClient();
        try {
            if (string.equalsIgnoreCase("still_alive")) {
                return new HTTPResponseProcessorText("I feel FANTASTIC and I'm still alive");
            }
            if (string.equalsIgnoreCase("cache_list")) {
                return new HTTPResponseProcessorCachelist(hentaiAtHomeClient.getCacheHandler());
            }
            if (string.equalsIgnoreCase("cache_files")) {
                return new HTTPResponseProcessorText(hentaiAtHomeClient.getServerHandler().downloadFilesFromServer(hashtable));
            }
            if (string.equalsIgnoreCase("proxy_test")) {
                String string3 = hashtable.get("ipaddr");
                int n = Integer.parseInt(hashtable.get("port"));
                String string4 = hashtable.get("fileid");
                String string5 = hashtable.get("keystamp");
                return new HTTPResponseProcessorText(hentaiAtHomeClient.getServerHandler().doProxyTest(string3, n, string4, string5));
            }
            if (string.equalsIgnoreCase("threaded_proxy_test")) {
                String string6 = hashtable.get("ipaddr");
                int n = Integer.parseInt(hashtable.get("port"));
                int n2 = Integer.parseInt(hashtable.get("testsize"));
                int n3 = Integer.parseInt(hashtable.get("testcount"));
                int n4 = Integer.parseInt(hashtable.get("testtime"));
                String string7 = hashtable.get("testkey");
                return new HTTPResponseProcessorText(hentaiAtHomeClient.getServerHandler().doThreadedProxyTest(string6, n, n2, n3, n4, string7));
            }
            if (string.equalsIgnoreCase("speed_test")) {
                String string8 = hashtable.get("testsize");
                return new HTTPResponseProcessorSpeedtest(string8 != null ? Integer.parseInt(string8) : 1000000);
            }
            if (string.equalsIgnoreCase("refresh_settings")) {
                return new HTTPResponseProcessorText(hentaiAtHomeClient.getServerHandler().refreshServerSettings() + "");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Out.warning(this.session + " Failed to process command");
        }
        return new HTTPResponseProcessorText("INVALID_COMMAND");
    }

    public void parseRequest(String string, boolean bl) {
        if (string == null) {
            this.responseStatusCode = 400;
            return;
        }
        String[] stringArray = string.trim().split(" ", 3);
        if (stringArray.length == 3) {
            if (!stringArray[0].equalsIgnoreCase("GET") && !stringArray[0].equalsIgnoreCase("HEAD") || !stringArray[2].startsWith("HTTP/")) {
                Out.warning(this.session + " HTTP request is not GET or HEAD.");
                this.responseStatusCode = 405;
                return;
            }
            this.validRequest = true;
            this.requestHeadOnly = stringArray[0].equalsIgnoreCase("HEAD");
            stringArray[1] = absoluteUriPattern.matcher(stringArray[1]).replaceFirst("/");
            String[] stringArray2 = stringArray[1].replace("%3d", "=").split("/");
            if (stringArray2.length < 2 || !stringArray2[0].equals("")) {
                Out.warning(this.session + " The requested URL is invalid or not supported.");
            } else {
                if (stringArray2[1].equals("h")) {
                    if (stringArray2.length < 4) {
                        this.responseStatusCode = 400;
                        return;
                    }
                    String string2 = stringArray2[2];
                    Hashtable<String, String> hashtable = MiscTools.parseAdditional(stringArray2[3]);
                    HVFile hVFile = this.session.getHTTPServer().getHentaiAtHomeClient().getCacheHandler().getHVFile(string2, !bl);
                    boolean bl2 = true;
                    String[] stringArray3 = hashtable.get("keystamp").split("-");
                    if (stringArray3.length == 2) {
                        try {
                            long l = Integer.parseInt(stringArray3[0]);
                            if (Math.abs((long)Settings.getServerTime() - l) < 900L && stringArray3[1].equalsIgnoreCase(MiscTools.getSHAString(l + "-" + string2 + "-" + Settings.getClientKey() + "-hotlinkthis").substring(0, 10))) {
                                bl2 = false;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl2) {
                        this.responseStatusCode = 403;
                    } else if (hVFile == null) {
                        Out.warning(this.session + " The requested file was invalid or not found in cache.");
                        this.responseStatusCode = 404;
                    } else {
                        String string3 = hVFile.getFileid();
                        if (hVFile.getLocalFileRef().exists()) {
                            this.hpc = new HTTPResponseProcessorFile(hVFile);
                        } else if (Settings.isStaticRange(string3)) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(string3);
                            Hashtable<String, String> hashtable2 = this.session.getHTTPServer().getHentaiAtHomeClient().getServerHandler().getFileTokens(arrayList);
                            if (hashtable2.containsKey(string3)) {
                                this.hpc = new HTTPResponseProcessorProxy(this.session, string3, hashtable2.get(string3), 1, 1, "ondemand");
                            } else {
                                this.responseStatusCode = 404;
                            }
                        } else {
                            this.responseStatusCode = 404;
                        }
                    }
                    return;
                }
                if (stringArray2[1].equals("servercmd")) {
                    if (!Settings.isValidRPCServer(this.session.getSocketInetAddress())) {
                        Out.warning(this.session + " Got a servercmd from an unauthorized IP address(" + this.session.getSocketInetAddress() + "): Denied");
                        this.responseStatusCode = 403;
                        return;
                    }
                    if (stringArray2.length < 6) {
                        Out.warning(this.session + " Got a malformed servercmd: Denied");
                        this.responseStatusCode = 403;
                        return;
                    }
                    String string4 = stringArray2[2];
                    String string5 = stringArray2[3];
                    int n = Integer.parseInt(stringArray2[4]);
                    String string6 = stringArray2[5];
                    int n2 = Settings.getServerTime();
                    if (Math.abs(n - n2) < 300 && MiscTools.getSHAString("hentai@home-servercmd-" + string4 + "-" + string5 + "-" + Settings.getClientID() + "-" + n + "-" + Settings.getClientKey()).equals(string6)) {
                        this.responseStatusCode = 200;
                        this.servercmd = true;
                        this.hpc = this.processRemoteAPICommand(string4, string5);
                        return;
                    }
                    Out.warning(this.session + " Got a servercmd with expired or incorrect key: Denied");
                    this.responseStatusCode = 403;
                    return;
                }
                if (stringArray2[1].equals("p")) {
                    boolean bl3;
                    int n = Settings.getRequestProxyMode();
                    boolean bl4 = n > 0;
                    boolean bl5 = n == 3 || n == 4;
                    boolean bl6 = bl3 = n == 1 || n == 3;
                    if (!bl4 || bl3 && !this.session.isLocalNetworkAccess()) {
                        Out.warning(this.session + " Proxy request denied for remote client.");
                    } else {
                        String string7;
                        Hashtable<String, String> hashtable = MiscTools.parseAdditional(stringArray2[2]);
                        String string8 = hashtable.get("fileid");
                        String string9 = hashtable.get("token");
                        String string10 = hashtable.get("gid");
                        String string11 = hashtable.get("page");
                        String string12 = hashtable.get("passkey");
                        String string13 = stringArray2[3];
                        boolean bl7 = false;
                        if (!bl5) {
                            bl7 = true;
                        } else if (string12 != null && (string7 = MiscTools.getSHAString(string8 + "I think we can put our differences behind us." + MiscTools.getSHAString(Settings.getClientKey() + "For science.").substring(0, 10) + "You monster.").substring(0, 10)).equals(string12)) {
                            bl7 = true;
                        }
                        if (!bl7) {
                            Out.warning(this.session + " Invalid passkey");
                        } else if (!(HVFile.isValidHVFileid(string8) && string9.matches("^\\d+-[a-z0-9]{40}$") && string10.matches("^\\d+$") && string11.matches("^\\d+$") && string13.matches("^(([a-zA-Z0-9])|(\\.)|(_))*$"))) {
                            Out.warning(this.session + " Failed argument validation");
                        } else {
                            try {
                                int n3 = Integer.parseInt(string10);
                                int n4 = Integer.parseInt(string11);
                                if (n3 > 0 && n4 > 0) {
                                    HVFile hVFile = this.session.getHTTPServer().getHentaiAtHomeClient().getCacheHandler().getHVFile(string8, true);
                                    if (hVFile != null && hVFile.getLocalFileRef().exists()) {
                                        this.hpc = new HTTPResponseProcessorFile(hVFile);
                                        return;
                                    }
                                    this.hpc = new HTTPResponseProcessorProxy(this.session, string8, string9, n3, n4, string13);
                                    return;
                                }
                                Out.warning(this.session + " gid and/or page are <= 0");
                            }
                            catch (Exception exception) {
                                Out.warning(this.session + " gid and/or page are not valid integers");
                            }
                        }
                    }
                } else {
                    if (stringArray2[1].equals("t")) {
                        if (stringArray2.length < 5) {
                            this.responseStatusCode = 400;
                            return;
                        }
                        int n = Integer.parseInt(stringArray2[2]);
                        int n5 = Integer.parseInt(stringArray2[3]);
                        String string14 = stringArray2[4];
                        Out.debug("Sending threaded proxy test with testsize=" + n + " testtime=" + n5 + " testkey=" + string14);
                        if (Math.abs(n5 - Settings.getServerTime()) > 300) {
                            Out.warning(this.session + " Got a speedtest request with expired key");
                            this.responseStatusCode = 403;
                            return;
                        }
                        if (!MiscTools.getSHAString("hentai@home-speedtest-" + n + "-" + n5 + "-" + Settings.getClientID() + "-" + Settings.getClientKey()).equals(string14)) {
                            Out.warning(this.session + " Got a speedtest request with invalid key");
                            this.responseStatusCode = 403;
                            return;
                        }
                        this.responseStatusCode = 200;
                        this.hpc = new HTTPResponseProcessorSpeedtest(n);
                        return;
                    }
                    if (stringArray2.length == 2) {
                        if (stringArray2[1].equals("favicon.ico")) {
                            this.hpc = new HTTPResponseProcessorText("");
                            this.hpc.addHeaderField("Location", "http://g.e-hentai.org/favicon.ico");
                            this.responseStatusCode = 301;
                            return;
                        }
                        if (stringArray2[1].equals("robots.txt")) {
                            this.hpc = new HTTPResponseProcessorText("User-agent: *\nDisallow: /", "text/plain");
                            this.responseStatusCode = 200;
                            return;
                        }
                        Out.warning(this.session + " Invalid request type '" + stringArray2[1] + "'.");
                    } else {
                        Out.warning(this.session + " Invalid request type '" + stringArray2[1] + "'.");
                    }
                }
            }
            this.responseStatusCode = 404;
            return;
        }
        Out.warning(this.session + " Invalid HTTP request form.");
        Out.warning(this.session + " Invalid HTTP request.");
        this.responseStatusCode = 400;
    }

    public HTTPResponseProcessor getHTTPResponseProcessor() {
        if (this.hpc == null) {
            this.hpc = new HTTPResponseProcessorText("An error has occurred. (" + this.responseStatusCode + ")");
            if (this.responseStatusCode == 405) {
                this.hpc.addHeaderField("Allow", "GET,HEAD");
            }
        } else if (this.hpc instanceof HTTPResponseProcessorFile) {
            this.responseStatusCode = this.hpc.initialize();
        } else if (this.hpc instanceof HTTPResponseProcessorProxy) {
            this.responseStatusCode = this.hpc.initialize();
        } else if (!(this.hpc instanceof HTTPResponseProcessorText)) {
            if (this.hpc instanceof HTTPResponseProcessorSpeedtest) {
                Stats.setProgramStatus("Running speed tests...");
            } else if (this.hpc instanceof HTTPResponseProcessorCachelist) {
                Stats.setProgramStatus("Building and sending cache list to server...");
                this.hpc.initialize();
            }
        }
        return this.hpc;
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public boolean isValidRequest() {
        return this.validRequest;
    }

    public boolean isRequestHeadOnly() {
        return this.requestHeadOnly;
    }

    public boolean isServercmd() {
        return this.servercmd;
    }
}

