/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.nio.charset.Charset;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import org.hath.base.CacheHandler;
import org.hath.base.HTTPResponseProcessor;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.Out;

public class HTTPResponseProcessorCachelist
extends HTTPResponseProcessor {
    private CacheHandler cacheHandler;
    private int cacheListWritten;
    private int segmentIndex;
    private int segmentCount;
    private StringBuilder fileidBuffer;

    public HTTPResponseProcessorCachelist(CacheHandler cacheHandler) {
        this.cacheHandler = cacheHandler;
    }

    @Override
    public int initialize() {
        this.cacheListWritten = 0;
        this.segmentIndex = 0;
        this.segmentCount = this.cacheHandler.getSegmentCount();
        this.fileidBuffer = new StringBuilder(1460 + Math.round(2 * this.cacheHandler.getStartupCachedFilesStrlen() / this.segmentCount));
        Out.info("Sending cache list, and waiting for the server to register the cached files.. (this could take a while)");
        return 200;
    }

    @Override
    public int getContentLength() {
        return this.cacheHandler.getStartupCachedFilesStrlen();
    }

    @Override
    public byte[] getBytes() {
        return this.getBytesRange(this.cacheHandler.getStartupCachedFilesStrlen());
    }

    @Override
    public byte[] getBytesRange(int n) {
        Object object;
        while (this.fileidBuffer.length() < n) {
            Out.info("Retrieving segment " + this.segmentIndex + " of " + this.segmentCount);
            if (this.segmentIndex >= this.segmentCount) {
                HentaiAtHomeClient.dieWithError("Segment out of range");
            }
            if (((LinkedList)(object = (Object)this.cacheHandler.getCachedFilesSegment(Integer.toHexString(this.segmentCount | this.segmentIndex++).substring(1)))).size() < 1) continue;
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.fileidBuffer.append(string + "\n");
            }
        }
        object = this.fileidBuffer.substring(0, n).getBytes(Charset.forName("ISO-8859-1"));
        this.fileidBuffer.delete(0, n);
        if (((byte[])object).length != n) {
            HentaiAtHomeClient.dieWithError("Length of cache list buffer (" + ((byte[])object).length + ") does not match requested length (" + n + ")! Bad program!");
        }
        this.cacheListWritten += ((byte[])object).length;
        return object;
    }
}

