/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.hath.base.HTTPResponseProcessor;
import org.hath.base.HVFile;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class HTTPResponseProcessorFile
extends HTTPResponseProcessor {
    private HVFile requestedHVFile;
    private BufferedInputStream bis;
    private int off;

    public HTTPResponseProcessorFile(HVFile hVFile) {
        this.requestedHVFile = hVFile;
        this.off = 0;
    }

    @Override
    public int initialize() {
        int n = 0;
        File file = this.requestedHVFile.getLocalFileRef();
        try {
            this.bis = new BufferedInputStream(new FileInputStream(file), Settings.isUseLessMemory() ? 8192 : 65536);
            n = 200;
            Stats.fileSent();
        }
        catch (IOException iOException) {
            Out.warning("Failed reading content from " + file);
            n = 500;
        }
        return n;
    }

    @Override
    public void cleanup() {
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getContentType() {
        return this.requestedHVFile.getMimeType();
    }

    @Override
    public int getContentLength() {
        if (this.bis != null) {
            return this.requestedHVFile.getSize();
        }
        return 0;
    }

    @Override
    public byte[] getBytes() {
        return this.getBytesRange(this.requestedHVFile.getSize());
    }

    @Override
    public byte[] getBytesRange(int n) {
        byte[] byArray = null;
        try {
            byArray = new byte[n];
            this.bis.read(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.off += n;
        return byArray;
    }
}

