/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.hath.base.HTTPResponseProcessor;
import org.hath.base.Out;

public class HTTPResponseProcessorText
extends HTTPResponseProcessor {
    private byte[] responseBytes;
    private int off;
    private String contentType;

    public HTTPResponseProcessorText(String string) {
        this(string, "text/html");
    }

    public HTTPResponseProcessorText(String string, String string2) {
        this(string, string2, Charset.forName("ISO-8859-1"));
    }

    public HTTPResponseProcessorText(String string, String string2, Charset charset) {
        int n = string.length();
        if (n > 0) {
            Out.debug("Response Written:");
            if (n < 10000) {
                Out.debug(string);
            } else {
                Out.debug("tl;dw");
            }
        }
        this.responseBytes = string.getBytes(charset);
        this.off = 0;
        this.contentType = string2 + "; charset=" + charset.name();
    }

    @Override
    public int getContentLength() {
        if (this.responseBytes != null) {
            return this.responseBytes.length;
        }
        return 0;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getBytes() {
        return this.responseBytes;
    }

    @Override
    public byte[] getBytesRange(int n) {
        byte[] byArray = Arrays.copyOfRange(this.responseBytes, this.off, Math.min(this.responseBytes.length, this.off + n));
        this.off += n;
        return byArray;
    }
}

