/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.hath.base.HTTPBandwidthMonitor;
import org.hath.base.HTTPSession;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class HTTPServer
implements Runnable {
    private HentaiAtHomeClient client;
    private HTTPBandwidthMonitor bandwidthMonitor;
    private ServerSocket ss;
    private Thread myThread;
    private List<HTTPSession> sessions;
    private int currentConnId;
    private boolean allowNormalConnections;
    private Hashtable<String, FloodControlEntry> floodControlTable;

    public HTTPServer(HentaiAtHomeClient hentaiAtHomeClient) {
        this.client = hentaiAtHomeClient;
        this.bandwidthMonitor = new HTTPBandwidthMonitor();
        this.sessions = Collections.checkedList(new ArrayList(), HTTPSession.class);
        this.ss = null;
        this.myThread = null;
        this.currentConnId = 0;
        this.allowNormalConnections = false;
        this.floodControlTable = new Hashtable();
    }

    public boolean startConnectionListener(int n) {
        try {
            Out.info("Starting up the internal HTTP Server...");
            if (this.ss != null) {
                this.stopConnectionListener();
            }
            this.ss = new ServerSocket(n);
            this.myThread = new Thread(this);
            this.myThread.start();
            Out.info("Internal HTTP Server was successfully started, and is listening on port " + n);
            return true;
        }
        catch (Exception exception) {
            this.allowNormalConnections();
            exception.printStackTrace();
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("Could not start the internal HTTP server.");
            Out.info("This is most likely caused by something else running on the port H@H is trying to use.");
            Out.info("In order to fix this, either shut down whatever else is using the port, or assign a different port to H@H.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            return false;
        }
    }

    public void stopConnectionListener() {
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneFloodControlTable() {
        List<String> list = Collections.checkedList(new ArrayList(), String.class);
        Hashtable<String, FloodControlEntry> hashtable = this.floodControlTable;
        synchronized (hashtable) {
            Enumeration<String> enumeration = this.floodControlTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!this.floodControlTable.get(string).isStale()) continue;
                list.add(string);
            }
            for (String string : list) {
                this.floodControlTable.remove(string);
            }
        }
        list.clear();
        list = null;
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nukeOldConnections(boolean bl) {
        List<HTTPSession> list = this.sessions;
        synchronized (list) {
            List<HTTPSession> list2 = Collections.checkedList(new ArrayList(), HTTPSession.class);
            for (HTTPSession hTTPSession : this.sessions) {
                if (!hTTPSession.doTimeoutCheck(bl)) continue;
                list2.add(hTTPSession);
            }
            for (HTTPSession hTTPSession : list2) {
                this.sessions.remove(hTTPSession);
            }
        }
    }

    public void allowNormalConnections() {
        this.allowNormalConnections = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                Socket socket = this.ss.accept();
                List<HTTPSession> list = this.sessions;
                // MONITORENTER : list
                boolean bl = false;
                InetAddress inetAddress = socket.getInetAddress();
                String string = inetAddress.toString();
                String string2 = Settings.getClientHost().replace("::ffff:", "");
                boolean bl2 = Pattern.matches("^((" + string2 + ")|(localhost)|(127\\.)|(10\\.)|(192\\.168\\.)|(172\\.((1[6-9])|(2[0-9])|(3[0-1]))\\.)|(169\\.254\\.)|(::1)|(0:0:0:0:0:0:0:1)|(fc)|(fd)).*$", inetAddress.getHostAddress());
                boolean bl3 = Settings.isValidRPCServer(inetAddress);
                if (!bl3 && !bl2) {
                    int n = Settings.getMaxConnections();
                    int n2 = this.sessions.size();
                    if (n2 > n) {
                        Out.warning("Exceeded the maximum allowed number of incoming connections (" + n + ").");
                        bl = true;
                    } else {
                        if ((double)n2 > (double)n * 0.8) {
                            this.client.getServerHandler().notifyOverload();
                        }
                        FloodControlEntry floodControlEntry = null;
                        Hashtable<String, FloodControlEntry> hashtable = this.floodControlTable;
                        // MONITORENTER : hashtable
                        floodControlEntry = this.floodControlTable.get(string);
                        if (floodControlEntry == null) {
                            floodControlEntry = new FloodControlEntry(inetAddress);
                            this.floodControlTable.put(string, floodControlEntry);
                        }
                        // MONITOREXIT : hashtable
                        if (!floodControlEntry.isBlocked()) {
                            if (!floodControlEntry.hit()) {
                                Out.warning("Flood control activated for  " + string + " (blocking for 60 seconds)");
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                } else {
                    HTTPSession hTTPSession = new HTTPSession(socket, this.getNewConnId(), bl2, this);
                    this.sessions.add(hTTPSession);
                    Stats.setOpenConnections(this.sessions.size());
                    hTTPSession.handleSession();
                }
                // MONITOREXIT : list
            }
        }
        catch (IOException iOException) {
            if (!this.client.isShuttingDown()) {
                Out.error("ServerSocket terminated unexpectedly!");
                HentaiAtHomeClient.dieWithError(iOException);
            } else {
                Out.info("ServerSocket was closed and will no longer accept new connections.");
            }
            this.ss = null;
            return;
        }
    }

    private synchronized int getNewConnId() {
        return ++this.currentConnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHTTPSession(HTTPSession hTTPSession) {
        List<HTTPSession> list = this.sessions;
        synchronized (list) {
            this.sessions.remove(hTTPSession);
            Stats.setOpenConnections(this.sessions.size());
        }
    }

    public HTTPBandwidthMonitor getBandwidthMonitor() {
        return this.bandwidthMonitor;
    }

    public HentaiAtHomeClient getHentaiAtHomeClient() {
        return this.client;
    }

    private class FloodControlEntry {
        private InetAddress addr;
        private int connectCount;
        private long lastConnect;
        private long blocktime;

        public FloodControlEntry(InetAddress inetAddress) {
            this.addr = inetAddress;
            this.connectCount = 0;
            this.lastConnect = 0L;
            this.blocktime = 0L;
        }

        public boolean isStale() {
            return this.lastConnect < System.currentTimeMillis() - 60000L;
        }

        public boolean isBlocked() {
            return this.blocktime > System.currentTimeMillis();
        }

        public boolean hit() {
            long l = System.currentTimeMillis();
            this.connectCount = Math.max(0, this.connectCount - (int)Math.floor((l - this.lastConnect) / 1000L)) + 1;
            this.lastConnect = l;
            if (this.connectCount > 10) {
                this.blocktime = l + 60000L;
                return false;
            }
            return true;
        }
    }
}

