/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.hath.base.HTTPBandwidthMonitor;
import org.hath.base.HTTPResponse;
import org.hath.base.HTTPResponseProcessor;
import org.hath.base.HTTPResponseProcessorFile;
import org.hath.base.HTTPResponseProcessorProxy;
import org.hath.base.HTTPServer;
import org.hath.base.Out;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class HTTPSession
implements Runnable {
    public static final String CRLF = "\r\n";
    private static final Pattern getheadPattern = Pattern.compile("^((GET)|(HEAD)).*", 2);
    private Socket mySocket;
    private HTTPServer httpServer;
    private int connId;
    private Thread myThread;
    private boolean localNetworkAccess;
    private long sessionStartTime = System.currentTimeMillis();
    private long lastPacketSend;
    private HTTPResponse hr;

    public HTTPSession(Socket socket, int n, boolean bl, HTTPServer hTTPServer) {
        this.mySocket = socket;
        this.connId = n;
        this.httpServer = hTTPServer;
        this.localNetworkAccess = bl;
    }

    public void handleSession() {
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    private void connectionFinished() {
        this.httpServer.removeHTTPSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block35: {
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            FilterOutputStream filterOutputStream = null;
            FilterOutputStream filterOutputStream2 = null;
            HTTPResponseProcessor hTTPResponseProcessor = null;
            String string = this.toString() + " ";
            try {
                int n;
                inputStreamReader = new InputStreamReader(this.mySocket.getInputStream());
                bufferedReader = new BufferedReader(inputStreamReader);
                filterOutputStream = new DataOutputStream(this.mySocket.getOutputStream());
                filterOutputStream2 = new BufferedOutputStream(filterOutputStream);
                String string2 = null;
                String string3 = null;
                int n2 = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    n2 += string2.length();
                    if (getheadPattern.matcher(string2).matches()) {
                        string3 = string2.substring(0, Math.min(10000, string2.length()));
                        continue;
                    }
                    if (!string2.isEmpty()) continue;
                }
                this.hr = new HTTPResponse(this);
                this.hr.parseRequest(string3, this.localNetworkAccess);
                hTTPResponseProcessor = this.hr.getHTTPResponseProcessor();
                int n3 = this.hr.getResponseStatusCode();
                int n4 = hTTPResponseProcessor.getContentLength();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                StringBuilder stringBuilder = new StringBuilder(300);
                stringBuilder.append(this.getHTTPStatusHeader(n3));
                stringBuilder.append(hTTPResponseProcessor.getHeader());
                stringBuilder.append("Date: " + simpleDateFormat.format(new Date()) + " GMT" + CRLF);
                stringBuilder.append("Server: Genetic Lifeform and Distributed Open Server 1.2.6\r\n");
                stringBuilder.append("Connection: close\r\n");
                stringBuilder.append("Content-Type: " + hTTPResponseProcessor.getContentType() + CRLF);
                if (n4 > 0) {
                    stringBuilder.append("Cache-Control: public, max-age=31536000\r\n");
                    stringBuilder.append("Content-Length: " + n4 + CRLF);
                }
                stringBuilder.append(CRLF);
                byte[] byArray = stringBuilder.toString().getBytes(Charset.forName("ISO-8859-1"));
                if (n4 > 0) {
                    try {
                        n = (int)Math.min((long)(n4 + byArray.length + 32), Math.min(Settings.isUseLessMemory() ? 131072L : 524288L, Math.round(0.2 * (double)Settings.getThrottleBytesPerSec())));
                        this.mySocket.setSendBufferSize(n);
                    }
                    catch (Exception exception) {
                        Out.info(exception.getMessage());
                    }
                }
                ((BufferedOutputStream)filterOutputStream2).write(byArray, 0, byArray.length);
                n = byArray.length;
                if (n >= 536) {
                    ((BufferedOutputStream)filterOutputStream2).flush();
                    n = 0;
                }
                if (this.hr.isRequestHeadOnly()) {
                    ((BufferedOutputStream)filterOutputStream2).flush();
                    string = string + "Code=" + n3 + " ";
                    Out.info(string + (string3 == null ? "Invalid Request" : string3));
                    break block35;
                }
                string = string + "Code=" + n3 + " Bytes=" + String.format("%1$-8s", n4) + " ";
                if (string3 != null) {
                    Out.info(string + string3);
                }
                long l = System.currentTimeMillis();
                if (n4 == 0) {
                    ((BufferedOutputStream)filterOutputStream2).flush();
                } else if (this.localNetworkAccess && (hTTPResponseProcessor instanceof HTTPResponseProcessorFile || hTTPResponseProcessor instanceof HTTPResponseProcessorProxy)) {
                    Out.debug(this + " Local network access detected, skipping throttle.");
                    if (hTTPResponseProcessor instanceof HTTPResponseProcessorProxy) {
                        int n5;
                        for (int i = 0; i < n4; i += n5) {
                            n5 = Math.min(1460 - n, n4 - i);
                            ((BufferedOutputStream)filterOutputStream2).write(hTTPResponseProcessor.getBytesRange(n5), 0, n5);
                            ((BufferedOutputStream)filterOutputStream2).flush();
                            n = 0;
                        }
                    } else {
                        ((BufferedOutputStream)filterOutputStream2).write(hTTPResponseProcessor.getBytes(), 0, n4);
                        ((BufferedOutputStream)filterOutputStream2).flush();
                    }
                } else {
                    int n6;
                    Stats.bytesRcvd(n2);
                    HTTPBandwidthMonitor hTTPBandwidthMonitor = this.httpServer.getBandwidthMonitor();
                    boolean bl = Settings.isDisableBWM();
                    int n7 = hTTPBandwidthMonitor.getActualPacketSize();
                    for (int i = 0; i < n4; i += n6) {
                        this.lastPacketSend = System.currentTimeMillis();
                        n6 = Math.min(n7 - n, n4 - i);
                        ((BufferedOutputStream)filterOutputStream2).write(hTTPResponseProcessor.getBytesRange(n6), 0, n6);
                        ((BufferedOutputStream)filterOutputStream2).flush();
                        n = 0;
                        Stats.bytesSent(n6);
                        if (bl) continue;
                        hTTPBandwidthMonitor.synchronizedWait(this.myThread);
                    }
                }
                long l2 = System.currentTimeMillis() - l;
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                Out.info(string + "Finished processing request in " + decimalFormat.format((double)l2 / 1000.0) + " seconds (" + (l2 > 0L ? decimalFormat.format((float)n4 / (float)l2) : "-.--") + " KB/s)");
            }
            catch (Exception exception) {
                Out.info(string + "The connection was interrupted or closed by the remote host.");
                Out.debug(exception == null ? "(no exception)" : exception.getMessage());
            }
            finally {
                if (hTTPResponseProcessor != null) {
                    hTTPResponseProcessor.cleanup();
                }
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    filterOutputStream2.close();
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    this.mySocket.close();
                }
                catch (Exception exception) {}
            }
        }
        this.connectionFinished();
    }

    private String getHTTPStatusHeader(int n) {
        switch (n) {
            case 200: {
                return "HTTP/1.1 200 OK\r\n";
            }
            case 301: {
                return "HTTP/1.1 301 Moved Permanently\r\n";
            }
            case 400: {
                return "HTTP/1.1 400 Bad Request\r\n";
            }
            case 403: {
                return "HTTP/1.1 403 Permission Denied\r\n";
            }
            case 404: {
                return "HTTP/1.1 404 Not Found\r\n";
            }
            case 405: {
                return "HTTP/1.1 405 Method Not Allowed\r\n";
            }
            case 418: {
                return "HTTP/1.1 418 I'm a teapot\r\n";
            }
            case 501: {
                return "HTTP/1.1 501 Not Implemented\r\n";
            }
            case 502: {
                return "HTTP/1.1 502 Bad Gateway\r\n";
            }
        }
        return "HTTP/1.1 500 Internal Server Error\r\n";
    }

    public boolean doTimeoutCheck(boolean bl) {
        int n;
        if (this.mySocket.isClosed()) {
            return true;
        }
        long l = System.currentTimeMillis();
        int n2 = this.hr != null ? (this.hr.isServercmd() ? 1800000 : 180000) : (n = 30000);
        if (bl || this.sessionStartTime > 0L && this.sessionStartTime < l - (long)n || this.lastPacketSend > 0L && this.lastPacketSend < l - 30000L) {
            try {
                this.mySocket.close();
            }
            catch (Exception exception) {
                Out.debug(exception.toString());
            }
        }
        return false;
    }

    public HTTPServer getHTTPServer() {
        return this.httpServer;
    }

    public InetAddress getSocketInetAddress() {
        return this.mySocket.getInetAddress();
    }

    public boolean isLocalNetworkAccess() {
        return this.localNetworkAccess;
    }

    public String toString() {
        return "{" + this.connId + String.format("%1$-17s", this.getSocketInetAddress().toString() + "}");
    }
}

