/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.hath.base.CacheHandler;
import org.hath.base.MiscTools;
import org.hath.base.Out;

public class HVFile {
    private String hash;
    private int size;
    private int xres;
    private int yres;
    private String type;

    private HVFile(String string, int n, int n2, int n3, String string2) {
        this.hash = string;
        this.size = n;
        this.xres = n2;
        this.yres = n3;
        this.type = string2;
    }

    public File getLocalFileRef() {
        return new File(CacheHandler.getCacheDir(), this.hash.substring(0, 2) + "/" + this.getFileid());
    }

    public boolean localFileMatches(File file) {
        try {
            return file.length() == (long)this.size && this.hash.startsWith(MiscTools.getSHAString(file));
        }
        catch (IOException iOException) {
            Out.warning("Failed reading file " + file + " to determine hash.");
            return false;
        }
    }

    public String getMimeType() {
        if (this.type.equals("jpg")) {
            return "image/jpeg";
        }
        if (this.type.equals("png")) {
            return "image/png";
        }
        if (this.type.equals("gif")) {
            return "image/gif";
        }
        if (this.type.equals("wbm")) {
            return "video/webm";
        }
        return "application/octet-stream";
    }

    public String getFileid() {
        return this.hash + "-" + this.size + "-" + this.xres + "-" + this.yres + "-" + this.type;
    }

    public String getHash() {
        return this.hash;
    }

    public int getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public static boolean isValidHVFileid(String string) {
        return Pattern.matches("^[a-f0-9]{40}-[0-9]{1,8}-[0-9]{1,5}-[0-9]{1,5}-((jpg)|(png)|(gif)|(wbm))$", string);
    }

    public static HVFile getHVFileFromFile(File file, boolean bl) {
        if (file.exists()) {
            String string = file.getName();
            try {
                if (bl && !string.startsWith(MiscTools.getSHAString(file))) {
                    return null;
                }
                return HVFile.getHVFileFromFileid(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Out.warning("Warning: Encountered IO error computing the hash value of " + file);
            }
        }
        return null;
    }

    public static HVFile getHVFileFromFileid(String string) {
        if (HVFile.isValidHVFileid(string)) {
            try {
                String[] stringArray = string.split("-");
                String string2 = stringArray[0];
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                int n3 = Integer.parseInt(stringArray[3]);
                String string3 = stringArray[4];
                return new HVFile(string2, n, n2, n3, string3);
            }
            catch (Exception exception) {
                Out.warning("Failed to parse fileid \"" + string + "\" : " + exception);
            }
        } else {
            Out.warning("Invalid fileid \"" + string + "\"");
        }
        return null;
    }

    public String toString() {
        return this.getFileid();
    }
}

