/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.IOException;
import org.hath.base.CacheHandler;
import org.hath.base.ClientAPI;
import org.hath.base.GalleryDownloadManager;
import org.hath.base.HTTPServer;
import org.hath.base.InputQueryHandler;
import org.hath.base.InputQueryHandlerCLI;
import org.hath.base.Out;
import org.hath.base.ServerHandler;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class HentaiAtHomeClient
implements Runnable {
    private InputQueryHandler iqh;
    private Out out;
    private ShutdownHook shutdownHook;
    private boolean shutdown;
    private boolean reportShutdown;
    private boolean fastShutdown;
    private HTTPServer httpServer;
    private ClientAPI clientAPI;
    private CacheHandler cacheHandler;
    private ServerHandler serverHandler;
    private GalleryDownloadManager galleryDownloadManager;
    private Thread myThread;
    private int threadSkipCounter;
    private long suspendedUntil;
    private String[] args;

    public HentaiAtHomeClient(InputQueryHandler inputQueryHandler, String[] stringArray) {
        this.iqh = inputQueryHandler;
        this.args = stringArray;
        this.shutdown = false;
        this.reportShutdown = false;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    @Override
    public void run() {
        this.out = new Out();
        HentaiAtHomeClient hentaiAtHomeClient = this;
        hentaiAtHomeClient.out.overrideDefaultOutput();
        Out.info("Hentai@Home 1.2.6 starting up");
        Out.info("");
        Out.info("Copyright (c) 2008-2014, E-Hentai.org - all rights reserved.");
        Out.info("This software comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to modify and redistribute it under the GPL v3 license.");
        Out.info("");
        String string = "sqlite-jdbc-3.7.2.jar";
        if (!new File(string).canRead()) {
            Out.error("Required library file " + string + " could not be found. Please make sure you are starting the program from the H@H directory, and that all H@H files are present.");
            System.exit(-1);
        }
        System.setProperty("http.keepAlive", "false");
        Settings.setActiveClient(this);
        Settings.parseArgs(this.args);
        Stats.resetStats();
        Stats.setProgramStatus("Logging in to main server...");
        this.clientAPI = new ClientAPI(this);
        if (Settings.loadClientLoginFromFile()) {
            Out.info("Loaded login settings from client_login");
        }
        if (!Settings.loginCredentialsAreSyntaxValid()) {
            Settings.promptForIDAndKey(this.iqh);
        }
        this.serverHandler = new ServerHandler(this);
        this.serverHandler.loadClientSettingsFromServer();
        Stats.setProgramStatus("Initializing cache handler...");
        try {
            this.cacheHandler = new CacheHandler(this);
            this.cacheHandler.initializeCacheHandler();
            this.cacheHandler.flushRecentlyAccessed();
        }
        catch (IOException iOException) {
            this.setFastShutdown();
            HentaiAtHomeClient.dieWithError(iOException);
            return;
        }
        Out.info("Calculating initial cache list file size...");
        this.cacheHandler.calculateStartupCachedFilesStrlen();
        Out.info("Calculated cacheListStrlen = " + this.cacheHandler.getStartupCachedFilesStrlen());
        Stats.setProgramStatus("Starting HTTP server...");
        this.httpServer = new HTTPServer(this);
        if (!this.httpServer.startConnectionListener(Settings.getClientPort())) {
            this.setFastShutdown();
            HentaiAtHomeClient.dieWithError("Failed to initialize HTTPServer");
            return;
        }
        Stats.setProgramStatus("Sending startup notification...");
        Out.info("Notifying the server that we have finished starting up the client...");
        if (!this.serverHandler.notifyStart()) {
            this.setFastShutdown();
            Out.info("Startup notification failed.");
            return;
        }
        this.httpServer.allowNormalConnections();
        this.reportShutdown = true;
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        if (Settings.isWarnNewClient()) {
            String string2 = "A new client version is available. Please download it from http://hentaiathome.net/ at your convenience.";
            Out.warning(string2);
            if (Settings.getActiveGUI() != null) {
                Settings.getActiveGUI().notifyWarning("New Version Available", string2);
            }
        }
        if (this.cacheHandler.getCacheCount() < 1) {
            Out.info("Important: Your cache does not yet contain any files.");
            Out.info("Because of this, you won't receive any traffic until the client has downloaded some files.");
            Out.info("This should usually happen within a few minutes, but traffic will take time to build up.");
            Out.info("The longer you run the client, the higher the utilization will become.");
        }
        this.serverHandler.refreshServerSettings();
        Out.info("Activated.");
        Stats.resetBytesSentHistory();
        Stats.programStarted();
        this.cacheHandler.processBlacklist(259200L, false);
        this.galleryDownloadManager = new GalleryDownloadManager(this);
        this.suspendedUntil = 0L;
        this.threadSkipCounter = 1;
        long l = 0L;
        System.gc();
        while (!this.shutdown) {
            try {
                Thread.sleep(Math.max(1000L, 10000L - l));
            }
            catch (InterruptedException interruptedException) {
                Out.debug("Master thread sleep interrupted");
            }
            long l2 = System.currentTimeMillis();
            if (!this.shutdown && this.suspendedUntil < System.currentTimeMillis()) {
                Stats.setProgramStatus("Running");
                if (this.suspendedUntil > 0L) {
                    this.resumeMasterThread();
                }
                if (this.threadSkipCounter % 30 == 0) {
                    this.serverHandler.stillAliveTest();
                }
                if (this.threadSkipCounter % 6 == 2) {
                    this.httpServer.pruneFloodControlTable();
                }
                if (this.threadSkipCounter % 30 == 15 && (int)(System.currentTimeMillis() / 1000L) - Stats.getLastServerContact() < 360) {
                    this.cacheHandler.pruneOldFiles();
                }
                if (this.threadSkipCounter % 2160 == 2159) {
                    this.cacheHandler.processBlacklist(43200L, false);
                }
                this.cacheHandler.flushRecentlyAccessed();
                this.httpServer.nukeOldConnections(false);
                Stats.shiftBytesSentHistory();
                ++this.threadSkipCounter;
            }
            l = System.currentTimeMillis() - l2;
        }
    }

    public boolean isSuspended() {
        return this.suspendedUntil > System.currentTimeMillis();
    }

    public boolean suspendMasterThread(int n) {
        if (n > 0 && n <= 86400 && this.suspendedUntil < System.currentTimeMillis()) {
            Stats.programSuspended();
            long l = n * 1000;
            this.suspendedUntil = System.currentTimeMillis() + l;
            Out.debug("Master thread suppressed for " + l / 1000L + " seconds.");
            return this.serverHandler.notifySuspend();
        }
        return false;
    }

    public boolean resumeMasterThread() {
        this.suspendedUntil = 0L;
        this.threadSkipCounter = 0;
        Stats.programResumed();
        return this.serverHandler.notifyResume();
    }

    public InputQueryHandler getInputQueryHandler() {
        return this.iqh;
    }

    public HTTPServer getHTTPServer() {
        return this.httpServer;
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public ClientAPI getClientAPI() {
        return this.clientAPI;
    }

    public static void dieWithError(Exception exception) {
        exception.printStackTrace();
        HentaiAtHomeClient.dieWithError(exception.toString());
    }

    public static void dieWithError(String string) {
        Out.error("Critical Error: " + string);
        Stats.setProgramStatus("Died");
        Settings.getActiveClient().shutdown(false, string);
    }

    public void setFastShutdown() {
        Out.flushLogs();
        this.fastShutdown = true;
    }

    public void shutdown() {
        this.shutdown(false, null);
    }

    private void shutdown(String string) {
        this.shutdown(false, string);
    }

    private void shutdown(boolean bl, String string) {
        Out.flushLogs();
        if (!this.shutdown) {
            this.shutdown = true;
            Out.info("Shutting down...");
            if (this.reportShutdown && this.serverHandler != null) {
                this.serverHandler.notifyShutdown();
            }
            if (!this.fastShutdown && this.httpServer != null) {
                this.httpServer.stopConnectionListener();
                Out.info("Shutdown in progress - please wait 25 seconds");
                try {
                    Thread.currentThread();
                    Thread.sleep(25000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Stats.getOpenConnections() > 0) {
                    this.httpServer.nukeOldConnections(true);
                    Out.info("All connections cleared.");
                }
            }
            if (this.cacheHandler != null) {
                this.cacheHandler.flushRecentlyAccessed();
                this.cacheHandler.terminateDatabase();
            }
            if (this.myThread != null) {
                this.myThread.interrupt();
            }
            if (Math.random() > 0.99) {
                Out.info("                             .,---.\n                           ,/XM#MMMX;,\n                         -%##########M%,\n                        -@######%  $###@=\n         .,--,         -H#######$   $###M:\n      ,;$M###MMX;     .;##########$;HM###X=\n    ,/@##########H=      ;################+\n   -+#############M/,      %##############+\n   %M###############=      /##############:\n   H################      .M#############;.\n   @###############M      ,@###########M:.\n   X################,      -$=X#######@:\n   /@##################%-     +######$-\n   .;##################X     .X#####+,\n    .;H################/     -X####+.\n      ,;X##############,       .MM/\n         ,:+$H@M#######M#$-    .$$=\n              .,-=;+$@###X:    ;/=.\n                     .,/X$;   .::,\n                         .,    ..    \n");
            } else {
                String[] stringArray = new String[]{"I don't hate you", "Whyyyyyyyy...", "No hard feelings", "Your business is appreciated", "Good-night"};
                Out.info(stringArray[(int)Math.floor(Math.random() * (double)stringArray.length)]);
            }
            if (string != null && Settings.getActiveGUI() != null) {
                Settings.getActiveGUI().notifyError(string);
            }
            Out.disableLogging();
        }
        if (!bl) {
            System.exit(0);
        }
    }

    public boolean isShuttingDown() {
        return this.shutdown;
    }

    public static void main(String[] stringArray) {
        InputQueryHandlerCLI inputQueryHandlerCLI = null;
        try {
            inputQueryHandlerCLI = InputQueryHandlerCLI.getIQHCLI();
            new HentaiAtHomeClient(inputQueryHandlerCLI, stringArray);
        }
        catch (Exception exception) {
            Out.error("Failed to initialize InputQueryHandler");
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            HentaiAtHomeClient.this.shutdown(true, null);
        }
    }
}

