/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hath.base.OutListener;
import org.hath.base.Settings;

public class Out {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 4;
    public static final int ERROR = 8;
    public static final int LOGOUT = 15;
    public static final int LOGERR = 12;
    public static final int OUTPUT = 14;
    public static final int VERBOSE = 8;
    private static int suppressedOutput;
    private static boolean overridden;
    private static boolean writeLogs;
    private static PrintStream def_out;
    private static PrintStream def_err;
    private static OutPrintStream or_out;
    private static OutPrintStream or_err;
    private static FileWriter logout;
    private static FileWriter logerr;
    private static int logout_count;
    private static int logerr_count;
    private static SimpleDateFormat sdf;
    private static List<OutListener> outListeners;

    public static void overrideDefaultOutput() {
        if (overridden) {
            return;
        }
        writeLogs = true;
        overridden = true;
        outListeners = new ArrayList<OutListener>();
        suppressedOutput = 0;
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        def_out = System.out;
        def_err = System.out;
        or_out = new OutPrintStream(def_out, "out", 2);
        or_err = new OutPrintStream(def_out, "ERR", 8);
        System.setOut(or_out);
        System.setErr(or_err);
        logout = Out.startLogger(Settings.getOutputLogPath());
        logerr = Out.startLogger(Settings.getErrorLogPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutListener(OutListener outListener) {
        List<OutListener> list = outListeners;
        synchronized (list) {
            if (!outListeners.contains(outListener)) {
                outListeners.add(outListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOutListener(OutListener outListener) {
        List<OutListener> list = outListeners;
        synchronized (list) {
            outListeners.remove(outListener);
        }
    }

    public static void disableLogging() {
        if (writeLogs) {
            Out.info("Logging ended.");
            writeLogs = false;
            Out.flushLogs();
        }
    }

    public static void flushLogs() {
        try {
            logout.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static FileWriter startLogger(String string) {
        FileWriter fileWriter = null;
        if (string != null) {
            new File(string + ".old").delete();
            new File(string).renameTo(new File(string + ".old"));
            if (string.length() > 0) {
                try {
                    fileWriter = new FileWriter(string, true);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println("Failed to open log file " + string);
                }
            }
        }
        if (fileWriter != null) {
            Out.log("\n" + sdf.format(new Date()) + " Logging started", fileWriter, true);
        }
        return fileWriter;
    }

    private static boolean stopLogger(FileWriter fileWriter) {
        try {
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(def_err);
            def_err.println("Unable to close file writer handle: Cannot rotate log.");
            return false;
        }
        return true;
    }

    public static void debug(String string) {
        or_out.println(string, "debug", 1);
    }

    public static void info(String string) {
        or_out.println(string, "info", 2);
    }

    public static void warning(String string) {
        or_out.println(string, "WARN", 4);
    }

    public static void error(String string) {
        or_out.println(string, "ERROR", 8);
    }

    private static synchronized void log(String string, int n) {
        if ((n & 0xF) > 0 && writeLogs) {
            Out.log(string, logout, false);
            if (++logout_count > 100000) {
                logout_count = 0;
                def_out.println("Rotating output logfile...");
                if (Out.stopLogger(logout)) {
                    logout = Out.startLogger(Settings.getOutputLogPath());
                    def_out.println("Output logfile rotated.");
                }
            }
        }
        if ((n & 0xC) > 0) {
            Out.log(string, logerr, true);
            if (++logerr_count > 100000) {
                logerr_count = 0;
                def_out.println("Rotating error logfile...");
                if (Out.stopLogger(logerr)) {
                    logerr = Out.startLogger(Settings.getErrorLogPath());
                    def_out.println("Error logfile rotated.");
                }
            }
        }
    }

    private static void log(String string, FileWriter fileWriter, boolean bl) {
        if (fileWriter != null) {
            try {
                fileWriter.write(string + "\n");
                if (bl) {
                    fileWriter.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(def_err);
            }
        }
    }

    public static String verbose(int n) {
        if ((n & 8) > 0) {
            String string;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            int n2 = 0;
            while (++n2 < stackTraceElementArray.length && ((string = stackTraceElementArray[n2].getClassName()).equals("org.hath.base.Out") || string.equals("org.hath.base.Out$OutPrintStream") || string.equals("java.lang.Thread"))) {
            }
            if (n2 < stackTraceElementArray.length) {
                if (!stackTraceElementArray[n2].getClassName().equals("java.lang.Throwable")) {
                    return "{" + stackTraceElementArray[n2] + "} ";
                }
                return "";
            }
            return "{Unknown Source}";
        }
        return "";
    }

    static {
        try {
            Settings.initializeDataDir();
        }
        catch (IOException iOException) {
            System.err.println("Could not create data directory. Please check file access permissions and free disk space.");
            System.exit(-1);
        }
        Out.overrideDefaultOutput();
    }

    private static class OutPrintStream
    extends PrintStream {
        private PrintStream ps;
        private String name;
        private int severity;
        private Out out;

        public OutPrintStream(PrintStream printStream, String string, int n) {
            super(printStream);
            this.ps = printStream;
            this.name = string;
            this.severity = n;
        }

        @Override
        public void println(String string) {
            this.println(string, this.name, this.severity);
        }

        public void println(String string, String string2) {
            this.println(string, string2, this.severity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(String string, String string2, int n) {
            boolean bl;
            if (string == null) {
                return;
            }
            boolean bl2 = (n & 0xE & ~suppressedOutput) > 0;
            boolean bl3 = bl = (n & 0xF) > 0;
            if (bl2 || bl) {
                List list = outListeners;
                synchronized (list) {
                    String[] stringArray;
                    String string3 = Out.verbose(n);
                    for (String string4 : stringArray = string.split("\n")) {
                        String string5 = sdf.format(new Date()) + " [" + string2 + "] " + string3 + string4;
                        if (bl2) {
                            this.ps.println(string5);
                            for (OutListener outListener : outListeners) {
                                outListener.outputWritten(string5);
                            }
                        }
                        if (!bl) continue;
                        Out.log(string5, n);
                    }
                }
            }
        }

        @Override
        public void println(boolean bl) {
            this.println(String.valueOf(bl));
        }

        @Override
        public void println(char c) {
            this.println(String.valueOf(c));
        }

        @Override
        public void println(char[] cArray) {
            this.println(new String(cArray));
        }

        @Override
        public void println(double d) {
            this.println(String.valueOf(d));
        }

        @Override
        public void println(float f) {
            this.println(String.valueOf(f));
        }

        @Override
        public void println(int n) {
            this.println(String.valueOf(n));
        }

        @Override
        public void println(long l) {
            this.println(String.valueOf(l));
        }

        @Override
        public void println(Object object) {
            this.println(String.valueOf(object));
        }
    }
}

