/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.hath.base.CacheHandler;
import org.hath.base.CakeSphere;
import org.hath.base.FileDownloader;
import org.hath.base.HVFile;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.MiscTools;
import org.hath.base.Out;
import org.hath.base.ServerResponse;
import org.hath.base.Settings;
import org.hath.base.Stats;

public class ServerHandler {
    public static final String ACT_SERVER_STAT = "server_stat";
    public static final String ACT_GET_BLACKLIST = "get_blacklist";
    public static final String ACT_CLIENT_LOGIN = "client_login";
    public static final String ACT_CLIENT_SETTINGS = "client_settings";
    public static final String ACT_CLIENT_START = "client_start";
    public static final String ACT_CLIENT_SUSPEND = "client_suspend";
    public static final String ACT_CLIENT_RESUME = "client_resume";
    public static final String ACT_CLIENT_STOP = "client_stop";
    public static final String ACT_STILL_ALIVE = "still_alive";
    public static final String ACT_FILE_UNCACHE = "file_uncache";
    public static final String ACT_FILE_REGISTER = "file_register";
    public static final String ACT_MORE_FILES = "more_files";
    public static final String ACT_FILE_TOKENS = "download_list";
    public static final String ACT_OVERLOAD = "overload";
    private HentaiAtHomeClient client;
    private static boolean loginValidated = false;
    private long lastOverloadNotification;

    public ServerHandler(HentaiAtHomeClient hentaiAtHomeClient) {
        this.client = hentaiAtHomeClient;
        this.lastOverloadNotification = 0L;
    }

    public static URL getServerConnectionURL(String string) {
        return ServerHandler.getServerConnectionURL(string, "");
    }

    public static URL getServerConnectionURL(String string, String string2) {
        URL uRL = null;
        try {
            if (string.equals(ACT_SERVER_STAT)) {
                uRL = new URL("http://rpc.hentaiathome.net/clientapi.php?clientbuild=98&act=" + string);
            } else {
                int n = Settings.getServerTime();
                String string3 = MiscTools.getSHAString("hentai@home-" + string + "-" + string2 + "-" + Settings.getClientID() + "-" + n + "-" + Settings.getClientKey());
                uRL = new URL("http://rpc.hentaiathome.net/clientapi.php?clientbuild=98&act=" + string + "&add=" + string2 + "&cid=" + Settings.getClientID() + "&acttime=" + n + "&actkey=" + string3);
            }
        }
        catch (MalformedURLException malformedURLException) {
            HentaiAtHomeClient.dieWithError(malformedURLException);
        }
        return uRL;
    }

    private boolean simpleNotification(String string, String string2) {
        ServerResponse serverResponse = ServerResponse.getServerResponse(string, this);
        if (serverResponse.getResponseStatus() == 1) {
            Out.debug(string2 + " notification successful.");
            return true;
        }
        Out.warning(string2 + " notification failed.");
        return false;
    }

    public boolean notifySuspend() {
        return this.simpleNotification(ACT_CLIENT_SUSPEND, "Suspend");
    }

    public boolean notifyResume() {
        return this.simpleNotification(ACT_CLIENT_RESUME, "Resume");
    }

    public boolean notifyShutdown() {
        return this.simpleNotification(ACT_CLIENT_STOP, "Shutdown");
    }

    public boolean notifyOverload() {
        long l = System.currentTimeMillis();
        if (this.lastOverloadNotification < l - 30000L) {
            this.lastOverloadNotification = l;
            return this.simpleNotification(ACT_OVERLOAD, "Overload");
        }
        return false;
    }

    public boolean notifyMoreFiles() {
        return this.simpleNotification(ACT_MORE_FILES, "More Files");
    }

    public boolean notifyStart() {
        ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_CLIENT_START, this);
        if (serverResponse.getResponseStatus() == 1) {
            Out.info("Start notification successful. Note that there may be a short wait before the server registers this client on the network.");
            return true;
        }
        String string = serverResponse.getFailCode();
        Out.info("failcode=" + string);
        if (string.startsWith("FAIL_CONNECT_TEST")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("The client has failed the external connection test.");
            Out.info("The server failed to verify that this client is online and available from the Internet.");
            Out.info("If you are behind a firewall, please check that port " + Settings.getClientPort() + " is forwarded to this computer.");
            Out.info("You might also want to check that " + Settings.getClientHost() + " is your actual public IP address.");
            Out.info("If you need assistance with forwarding a port to this client, locate a guide for your particular router at http://portforward.com/");
            Out.info("The client will remain running so you can run port connection tests.");
            Out.info("Use Program -> Exit in windowed mode or hit Ctrl+C in console mode to exit the program.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            return false;
        }
        if (string.startsWith("FAIL_STARTUP_FLOOD")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("Flood control is in effect.");
            Out.info("The client will automatically retry connecting in 90 seconds.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            try {
                Thread.currentThread();
                Thread.sleep(90000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.notifyStart();
        }
        if (string.startsWith("FAIL_OTHER_CLIENT_CONNECTED")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("The server detected that another client was already connected from this computer or local network.");
            Out.info("You can only have one client running per public IP address.");
            Out.info("The program will now terminate.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            HentaiAtHomeClient.dieWithError("FAIL_OTHER_CLIENT_CONNECTED");
        } else if (string.startsWith("FAIL_CID_IN_USE")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("The server detected that another client is already using this client ident.");
            Out.info("If you want to run more than one client, you have to apply for additional idents.");
            Out.info("The program will now terminate.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            HentaiAtHomeClient.dieWithError("FAIL_CID_IN_USE");
        } else if (string.startsWith("FAIL_RESET_SUSPENDED")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("This client ident has been revoked for having too many cache resets.");
            Out.info("The program will now terminate.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            HentaiAtHomeClient.dieWithError("FAIL_RESET_SUSPENDED");
        }
        return false;
    }

    public void notifyUncachedFiles(List<HVFile> list) {
        int n = list.size();
        if (n > 0) {
            Out.debug("Notifying server of " + n + " uncached files...");
            do {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n > 0 && ++n2 <= 50) {
                    stringBuffer.append((n2 != 1 ? ";" : "") + list.remove(--n).getFileid());
                }
                URL uRL = ServerHandler.getServerConnectionURL(ACT_FILE_UNCACHE, stringBuffer.toString());
                ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
                if (serverResponse.getResponseStatus() == 1) {
                    Out.debug("Uncache notification successful.");
                    continue;
                }
                Out.warning("Uncache notification failed.");
            } while (n > 0);
        }
    }

    public void notifyRegisterFiles(List<HVFile> list) {
        int n = list.size();
        Out.debug("Notifying server of " + n + " registered files...");
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            stringBuffer.append((stringBuffer.length() > 0 ? ";" : "") + list.remove(--n).getFileid());
        }
        URL uRL = ServerHandler.getServerConnectionURL(ACT_FILE_REGISTER, stringBuffer.toString());
        ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
        if (serverResponse.getResponseStatus() == 1) {
            Out.debug("Register notification successful.");
        } else {
            Out.warning("Register notification failed.");
        }
    }

    public String[] getBlacklist(long l) {
        URL uRL = ServerHandler.getServerConnectionURL(ACT_GET_BLACKLIST, "" + l);
        ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
        if (serverResponse.getResponseStatus() == 1) {
            return serverResponse.getResponseText();
        }
        return null;
    }

    public void stillAliveTest() {
        CakeSphere cakeSphere = new CakeSphere(this, this.client);
        cakeSphere.stillAlive();
    }

    public void loadClientSettingsFromServer() {
        Stats.setProgramStatus("Loading settings from server...");
        Out.info("Connecting to the Hentai@Home Server to register client with ID " + Settings.getClientID() + "...");
        try {
            do {
                if (!this.refreshServerStat()) {
                    HentaiAtHomeClient.dieWithError("Failed to get initial stat from server.");
                }
                Out.info("Reading Hentai@Home client settings from server...");
                ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_CLIENT_LOGIN, this);
                if (serverResponse.getResponseStatus() == 1) {
                    loginValidated = true;
                    Out.info("Server returns client settings:");
                    Out.info(serverResponse.toString());
                    Out.info("Applying settings...");
                    Settings.parseAndUpdateSettings(serverResponse.getResponseText());
                    Out.info("Finished applying settings");
                    continue;
                }
                if (serverResponse.getResponseStatus() == 0) {
                    HentaiAtHomeClient.dieWithError("Failed to get a login response from server.");
                    continue;
                }
                Out.warning("\nAuthentication failed, please re-enter your Client ID and Key (Code: " + serverResponse.getFailCode() + ")");
                Settings.promptForIDAndKey(this.client.getInputQueryHandler());
            } while (!loginValidated);
        }
        catch (Exception exception) {
            HentaiAtHomeClient.dieWithError(exception);
        }
    }

    public boolean refreshServerSettings() {
        Out.info("Refreshing Hentai@Home client settings from server...");
        ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_CLIENT_SETTINGS, this);
        if (serverResponse.getResponseStatus() == 1) {
            Settings.parseAndUpdateSettings(serverResponse.getResponseText());
            Out.info("Finished applying settings");
            return true;
        }
        Out.warning("Failed to refresh settings");
        return false;
    }

    public boolean refreshServerStat() {
        Stats.setProgramStatus("Getting initial stats from server...");
        ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_SERVER_STAT, this);
        if (serverResponse.getResponseStatus() == 1) {
            Settings.parseAndUpdateSettings(serverResponse.getResponseText());
            return true;
        }
        return false;
    }

    public Hashtable<String, String> getFileTokens(List<String> list) {
        String string = "";
        for (String object2 : list) {
            string = string.concat(object2 + ";");
        }
        URL uRL = ServerHandler.getServerConnectionURL(ACT_FILE_TOKENS, string);
        ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
        if (serverResponse.getResponseStatus() == 1) {
            String[] stringArray;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (String string2 : stringArray = serverResponse.getResponseText()) {
                if (string2.isEmpty()) continue;
                String[] stringArray2 = string2.split(" ", 2);
                hashtable.put(stringArray2[0], stringArray2[1]);
            }
            return hashtable;
        }
        Out.info("Could not grab token list - most likely the client has not been qualified yet. Will retry in a few minutes.");
        return null;
    }

    public static boolean isLoginValidated() {
        return loginValidated;
    }

    public String downloadFilesFromServer(Hashtable<String, String> hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = hashtable.keys();
        try {
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = hashtable.get(string);
                String[] stringArray = string.split(":");
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                if (HVFile.isValidHVFileid(string3) && string2.matches("^[0-9]{6}-[a-z0-9]{40}$")) {
                    URL uRL = new URL("http", string4, 80, "/image.php?f=" + string3 + "&t=" + string2);
                    if (this.downloadAndCacheFile(uRL, string3)) {
                        stringBuffer.append(string3 + ":OK\n");
                        continue;
                    }
                    stringBuffer.append(string3 + ":FAIL\n");
                    continue;
                }
                stringBuffer.append(string3 + ":INVALID\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Out.warning("Encountered error " + exception + " when downloading image files from server. Will not retry.");
        }
        return stringBuffer.toString();
    }

    public String doThreadedProxyTest(String string, int n, int n2, int n3, int n4, String string2) {
        int n5 = 0;
        long l = 0L;
        Out.debug("Running threaded proxy test against ipaddr=" + string + " port=" + n + " testsize=" + n2 + " testcount=" + n3 + " testtime=" + n4 + " testkey=" + string2);
        try {
            List<FileDownloader> list = Collections.checkedList(new ArrayList(), FileDownloader.class);
            for (int i = 0; i < n3; ++i) {
                URL object = new URL("http", string, n, "/t/" + n2 + "/" + n4 + "/" + string2 + "/" + (int)Math.floor(Math.random() * 2.147483647E9));
                Out.debug("Test thread: " + object);
                FileDownloader fileDownloader = new FileDownloader(object, 10000, 60000);
                list.add(fileDownloader);
                fileDownloader.startAsyncDownload();
            }
            for (FileDownloader fileDownloader : list) {
                if (!fileDownloader.waitAsyncDownload()) continue;
                ++n5;
                l += fileDownloader.getDownloadTimeMillis();
            }
        }
        catch (MalformedURLException malformedURLException) {
            HentaiAtHomeClient.dieWithError(malformedURLException);
        }
        return "OK:" + n5 + "-" + l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doProxyTest(String string, int n, String string2, String string3) {
        if (!HVFile.isValidHVFileid(string2)) {
            Out.error("Encountered an invalid fileid in doProxyTest: " + string2);
            return string2 + ":INVALID-0";
        }
        try {
            URL uRL = new URL("http", string, n, "/h/" + string2 + "/keystamp=" + string3 + "/test.jpg");
            Out.info("Running a proxy test against " + uRL + ".");
            int n2 = 0;
            if (!string.matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
                Out.warning("Invalid IP address: " + string);
            } else {
                String string4 = null;
                String string5 = System.getProperty("os.name");
                if (string5 != null && string5.toLowerCase().indexOf("windows") > -1) {
                    string4 = "ping -n 3 " + string;
                }
                if (string4 == null) {
                    string4 = "ping -c 3 " + string;
                }
                Process process = null;
                InputStreamReader inputStreamReader = null;
                BufferedReader bufferedReader = null;
                int n3 = 0;
                int n4 = 0;
                try {
                    process = Runtime.getRuntime().exec(string4);
                    inputStreamReader = new InputStreamReader(process.getInputStream());
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String string6 = null;
                    while ((string6 = bufferedReader.readLine()) != null) {
                        int n5 = string6.indexOf("time=");
                        if (n5 < 0) continue;
                        int n6 = n5 + 5;
                        int n7 = string6.indexOf("ms", n6);
                        if (n6 <= 0 || n7 <= 0) continue;
                        n3 += (int)Double.parseDouble(string6.substring(n6, n7).trim());
                        ++n4;
                    }
                    if (n4 > 0) {
                        n2 = n3 / n4;
                    }
                }
                catch (Exception exception) {
                    Out.debug("Encountered exception " + exception + " while trying to ping remote client");
                }
                finally {
                    try {
                        bufferedReader.close();
                        inputStreamReader.close();
                        process.destroy();
                    }
                    catch (Exception exception) {}
                }
            }
            if (n2 > 0) {
                Out.debug("Approximate latency determined as ~" + n2 + " ms");
            } else {
                Out.debug("Could not determine latency, conservatively guessing 20ms");
                n2 = 20;
            }
            long l = System.currentTimeMillis();
            if (this.downloadAndCacheFile(uRL, string2)) {
                long l2 = System.currentTimeMillis() - l;
                n2 = Math.min(200, n2);
                double d = Math.max(0.0, ((double)l2 * (1.0 - (double)n2 / 1000.0) - (double)(n2 * 3)) / 1000.0);
                Out.debug("Clocked a download time of " + l2 + " ms. Ping delay fiddling reduced estimate to " + d + " seconds.");
                return string2 + ":OK-" + d;
            }
        }
        catch (Exception exception) {
            Out.warning("Encountered error " + exception + " when doing proxy test against " + string + ":" + n + " on file " + string2 + ". Will not retry.");
        }
        return string2 + ":FAIL-0";
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean downloadAndCacheFile(URL uRL, String string) {
        FileDownloader fileDownloader;
        if (!HVFile.isValidHVFileid(string)) {
            Out.warning("Encountered invalid fileid " + string);
            return false;
        }
        CacheHandler cacheHandler = this.client.getCacheHandler();
        File file = new File(cacheHandler.getTmpDir(), string);
        if (file.exists()) {
            file.delete();
        }
        if ((fileDownloader = new FileDownloader(uRL, 10000, 30000)).saveFile(file)) {
            HVFile hVFile = HVFile.getHVFileFromFile(file, true);
            if (hVFile != null) {
                if (!hVFile.getLocalFileRef().exists()) {
                    if (!cacheHandler.moveFileToCacheDir(file, hVFile)) {
                        Out.warning("Failed to insert " + string + " into cache.");
                        file.delete();
                        return false;
                    }
                    cacheHandler.addFileToActiveCache(hVFile);
                    Out.info("The file " + string + " was successfully downloaded and inserted into the active cache.");
                } else {
                    Out.info("The file " + string + " was successfully downloaded, but already exists in the cache.");
                    file.delete();
                }
                Stats.fileRcvd();
                return true;
            }
            Out.warning("Downloaded file " + string + " failed hash verification. Will not retry.");
        } else {
            Out.warning("Failed downloading file " + string + " from " + uRL + ". Will not retry.");
        }
        if (!file.exists()) return false;
        file.delete();
        return false;
    }
}

