/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.net.URL;
import java.util.Arrays;
import org.hath.base.FileDownloader;
import org.hath.base.Out;
import org.hath.base.ServerHandler;
import org.hath.base.Stats;

public class ServerResponse {
    public static final int RESPONSE_STATUS_NULL = 0;
    public static final int RESPONSE_STATUS_OK = 1;
    public static final int RESPONSE_STATUS_FAIL = -1;
    private int responseStatus;
    private String[] responseText;
    private String failCode;

    private ServerResponse(int n, String[] stringArray) {
        this.responseStatus = n;
        this.responseText = stringArray;
        this.failCode = null;
    }

    private ServerResponse(int n, String string) {
        this.responseStatus = n;
        this.failCode = string;
        this.responseText = null;
    }

    public static ServerResponse getServerResponse(String string, ServerHandler serverHandler) {
        URL uRL = ServerHandler.getServerConnectionURL(string);
        return ServerResponse.getServerResponse(uRL, serverHandler, string);
    }

    public static ServerResponse getServerResponse(URL uRL, ServerHandler serverHandler) {
        return ServerResponse.getServerResponse(uRL, serverHandler, null);
    }

    private static ServerResponse getServerResponse(URL uRL, ServerHandler serverHandler, String string) {
        FileDownloader fileDownloader = new FileDownloader(uRL, 3600000);
        String string2 = fileDownloader.getTextContent();
        if (string2 == null) {
            return new ServerResponse(0, "NO_RESPONSE");
        }
        if (string2.length() < 1) {
            return new ServerResponse(0, "NO_RESPONSE");
        }
        String[] stringArray = string2.split("\n");
        Out.debug("Received response: " + string2);
        if (stringArray.length < 1) {
            return new ServerResponse(0, "NO_RESPONSE");
        }
        if (stringArray[0].startsWith("Log Code") || stringArray[0].startsWith("Database Error")) {
            return new ServerResponse(0, "SERVER_ERROR");
        }
        if (stringArray[0].startsWith("TEMPORARILY_UNAVAILABLE")) {
            return new ServerResponse(0, "TEMPORARILY_UNAVAILABLE");
        }
        if (stringArray[0].equals("OK")) {
            Stats.serverContact();
            return new ServerResponse(1, Arrays.copyOfRange(stringArray, 1, stringArray.length));
        }
        if (stringArray[0].equals("KEY_EXPIRED") && serverHandler != null && string != null) {
            Out.warning("Server reported expired key; attempting to refresh time from server and retrying");
            serverHandler.refreshServerStat();
            return ServerResponse.getServerResponse(ServerHandler.getServerConnectionURL(string), null);
        }
        return new ServerResponse(-1, stringArray[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.responseText != null) {
            for (String string : this.responseText) {
                stringBuffer.append(string + ",");
            }
        }
        return "ServerResponse {responseStatus=" + this.responseStatus + ", responseText=" + stringBuffer.toString() + ", failCode=" + this.failCode + "}";
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String[] getResponseText() {
        return this.responseText;
    }

    public String getFailCode() {
        return this.failCode;
    }
}

