/*
 * Decompiled with CFR 0.152.
 */
package org.hath.base;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.hath.base.FileTools;
import org.hath.base.HathGUI;
import org.hath.base.HentaiAtHomeClient;
import org.hath.base.InputQueryHandler;
import org.hath.base.Out;
import org.hath.base.Stats;

public class Settings {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int CLIENT_BUILD = 98;
    public static final String CLIENT_VERSION = "1.2.6";
    public static final String CLIENT_API_URL = "http://rpc.hentaiathome.net/clientapi.php?";
    public static final String DATA_FILENAME_CLIENT_LOGIN = "client_login";
    public static final String DATA_FILENAME_LASTHIT_HISTORY = "lasthit_history";
    public static final int CLIENT_KEY_LENGTH = 20;
    public static final int MAX_KEY_TIME_DRIFT = 300;
    public static final int MAX_CONNECTION_BASE = 20;
    public static final String CONTENT_TYPE_DEFAULT = "text/html; charset=iso-8859-1";
    public static final String CONTENT_TYPE_OCTET = "application/octet-stream";
    public static final String CONTENT_TYPE_JPG = "image/jpeg";
    public static final String CONTENT_TYPE_PNG = "image/png";
    public static final String CONTENT_TYPE_GIF = "image/gif";
    public static final String CONTENT_TYPE_WEBM = "video/webm";
    public static final int TCP_PACKET_SIZE_HIGH = 1460;
    public static final int TCP_PACKET_SIZE_LOW = 536;
    public static final int MAX_REQUEST_LENGTH = 10000;
    private static HentaiAtHomeClient activeClient;
    private static HathGUI activeGUI;
    private static int clientID;
    private static String clientKey;
    private static int serverTimeDelta;
    private static Object rpcChangeMonitor;
    private static InetAddress[] rpcServers;
    private static String imageServer;
    private static String clientName;
    private static String clientHost;
    private static int clientPort;
    private static String requestServer;
    private static int requestProxyMode;
    private static int throttle_bytes;
    private static long hourbwlimit_bytes;
    private static long disklimit_bytes;
    private static long diskremaining_bytes;
    private static boolean forceDirty;
    private static boolean verifyCache;
    private static boolean skipFreeSpaceCheck;
    private static boolean warnNewClient;
    private static boolean useLessMemory;
    private static boolean disableBWM;
    private static String proxyHost;
    private static int proxyPort;
    private static int proxyType;
    private static int overrideConns;
    private static File datadir;
    private static Hashtable<String, Integer> staticRanges;

    public static void setActiveClient(HentaiAtHomeClient hentaiAtHomeClient) {
        activeClient = hentaiAtHomeClient;
    }

    public static void setActiveGUI(HathGUI hathGUI) {
        activeGUI = hathGUI;
    }

    public static boolean loginCredentialsAreSyntaxValid() {
        return clientID > 0 && Pattern.matches("^[a-zA-Z0-9]{20}$", clientKey);
    }

    public static boolean loadClientLoginFromFile() {
        File file = new File(Settings.getDataDir(), DATA_FILENAME_CLIENT_LOGIN);
        if (!file.exists()) {
            return false;
        }
        try {
            String[] stringArray;
            String string = FileTools.getStringFileContents(file);
            if (!string.isEmpty() && (stringArray = string.split("-", 2)).length == 2) {
                clientID = Integer.parseInt(stringArray[0]);
                clientKey = stringArray[1];
                return true;
            }
        }
        catch (Exception exception) {
            Out.warning("Encountered error when reading client_login: " + exception);
        }
        return false;
    }

    public static void promptForIDAndKey(InputQueryHandler inputQueryHandler) {
        Out.info("Before you can use this client, you will have to register it at http://hentaiathome.net/");
        Out.info("IMPORTANT: YOU NEED A SEPARATE IDENT FOR EACH CLIENT YOU WANT TO RUN.");
        Out.info("DO NOT ENTER AN IDENT THAT WAS ASSIGNED FOR A DIFFERENT CLIENT.");
        Out.info("After registering, enter your ID and Key below to start your client.");
        Out.info("(You will only have to do this once.)\n");
        clientID = 0;
        clientKey = "";
        do {
            try {
                clientID = Integer.parseInt(inputQueryHandler.queryString("Enter Client ID").trim());
            }
            catch (NumberFormatException numberFormatException) {
                Out.warning("Invalid Client ID. Please try again.");
            }
        } while (clientID < 1000);
        do {
            clientKey = inputQueryHandler.queryString("Enter Client Key").trim();
            if (Settings.loginCredentialsAreSyntaxValid()) continue;
            Out.warning("Invalid Client Key, it must be exactly 20 alphanumerical characters. Please try again.");
        } while (!Settings.loginCredentialsAreSyntaxValid());
        try {
            FileTools.putStringFileContents(new File(Settings.getDataDir(), DATA_FILENAME_CLIENT_LOGIN), clientID + "-" + clientKey);
        }
        catch (IOException iOException) {
            Out.warning("Error encountered when writing client_login: " + iOException);
        }
    }

    public static boolean parseAndUpdateSettings(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            String[] stringArray2;
            if (string == null || (stringArray2 = string.split("=", 2)).length != 2) continue;
            Settings.updateSetting(stringArray2[0].toLowerCase(), stringArray2[1]);
        }
        return true;
    }

    public static boolean parseArgs(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            if (string.startsWith("--")) {
                String[] stringArray2 = string.substring(2).split("=", 2);
                if (stringArray2.length == 2) {
                    Settings.updateSetting(stringArray2[0].toLowerCase(), stringArray2[1]);
                    continue;
                }
                Settings.updateSetting(stringArray2[0].toLowerCase(), "true");
                continue;
            }
            Out.warning("Invalid command argument: " + string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateSetting(String string, String string2) {
        string = string.replace("-", "_");
        try {
            if (string.equals("min_client_build")) {
                if (Integer.parseInt(string2) > 98) {
                    HentaiAtHomeClient.dieWithError("Your client is too old to connect to the Hentai@Home Network. Please download the new version of the client from http://hentaiathome.net/");
                }
            } else if (string.equals("cur_client_build")) {
                if (Integer.parseInt(string2) > 98) {
                    warnNewClient = true;
                }
            } else {
                if (string.equals("server_time")) {
                    serverTimeDelta = Integer.parseInt(string2) - (int)(System.currentTimeMillis() / 1000L);
                    Out.debug("Setting altered: serverTimeDelta=" + serverTimeDelta);
                    return true;
                }
                if (string.equals("rpc_server_ip")) {
                    Object object = rpcChangeMonitor;
                    synchronized (object) {
                        String[] stringArray = string2.split(";");
                        rpcServers = new InetAddress[stringArray.length + 1];
                        int n = 0;
                        for (String string3 : stringArray) {
                            Settings.rpcServers[n++] = InetAddress.getByName(string3);
                        }
                        Settings.rpcServers[n] = InetAddress.getByName("::ffff:127.0.0.1");
                        Settings.rpcServers[n] = InetAddress.getByName("::ffff:" + proxyHost);
                    }
                } else if (string.equals("image_server")) {
                    imageServer = string2;
                } else if (string.equals("name")) {
                    clientName = string2;
                } else if (string.equals("host")) {
                    clientHost = string2;
                } else if (string.equals("port")) {
                    if (clientPort == 0) {
                        clientPort = Integer.parseInt(string2);
                    }
                } else if (string.equals("request_server")) {
                    requestServer = string2;
                } else if (string.equals("request_proxy_mode")) {
                    requestProxyMode = Integer.parseInt(string2);
                } else if (string.equals("throttle_bytes")) {
                    throttle_bytes = Integer.parseInt(string2);
                } else if (string.equals("hourbwlimit_bytes")) {
                    hourbwlimit_bytes = Long.parseLong(string2);
                } else if (string.equals("disklimit_bytes")) {
                    long l = Long.parseLong(string2);
                    if (l >= disklimit_bytes) {
                        disklimit_bytes = l;
                    } else {
                        Out.warning("The disk limit has been reduced. However, this change will not take effect until you restart your client.");
                    }
                } else if (string.equals("diskremaining_bytes")) {
                    diskremaining_bytes = Long.parseLong(string2);
                } else if (string.equals("force_dirty")) {
                    forceDirty = string2.equals("true");
                } else if (string.equals("verify_cache")) {
                    verifyCache = string2.equals("true");
                } else if (string.equals("use_less_memory")) {
                    useLessMemory = string2.equals("true");
                } else if (string.equals("disable_logging")) {
                    Out.disableLogging();
                } else if (string.equals("disable_bwm")) {
                    disableBWM = string2.equals("true");
                } else if (string.equals("skip_free_space_check")) {
                    skipFreeSpaceCheck = string2.equals("true");
                } else if (string.equals("max_connections")) {
                    overrideConns = Integer.parseInt(string2);
                } else if (string.equals("static_ranges")) {
                    String[] stringArray;
                    staticRanges = new Hashtable();
                    for (String string4 : stringArray = string2.split(";")) {
                        if (string4.length() != 4) continue;
                        staticRanges.put(string4, 1);
                    }
                } else if (string.equals("proxy_host")) {
                    proxyHost = string2;
                    Out.warning("ProxyHost: " + string2);
                } else if (string.equals("proxy_port")) {
                    proxyPort = Integer.parseInt(string2);
                    Out.warning("ProxyPort: " + string2);
                } else if (string.equals("proxy_type")) {
                    proxyType = Integer.parseInt(string2);
                    Out.warning("ProxyType " + string2);
                } else if (!string.equals("silentstart")) {
                    Out.warning("Unknown setting " + string + " = " + string2);
                    return false;
                }
            }
            Out.debug("Setting altered: " + string + "=" + string2);
            return true;
        }
        catch (Exception exception) {
            Out.warning("Failed parsing setting " + string + " = " + string2);
            return false;
        }
    }

    public static void initializeDataDir() throws IOException {
        datadir = FileTools.checkAndCreateDir(new File("data"));
    }

    public static File getDataDir() {
        return datadir;
    }

    public static int getClientID() {
        return clientID;
    }

    public static String getClientKey() {
        return clientKey;
    }

    public static String getImageServer(String string) {
        return imageServer;
    }

    public static String getClientName() {
        return clientName;
    }

    public static String getClientHost() {
        return clientHost;
    }

    public static int getClientPort() {
        return clientPort;
    }

    public static String getRequestServer() {
        return requestServer;
    }

    public static int getRequestProxyMode() {
        return requestProxyMode;
    }

    public static int getThrottleBytesPerSec() {
        return throttle_bytes;
    }

    public static long getHourBWLimitBytes() {
        return hourbwlimit_bytes;
    }

    public static long getDiskLimitBytes() {
        return disklimit_bytes;
    }

    public static long getDiskMinRemainingBytes() {
        return diskremaining_bytes;
    }

    public static int getServerTime() {
        return (int)(System.currentTimeMillis() / 1000L) + serverTimeDelta;
    }

    public static String getOutputLogPath() {
        return "data/log_out";
    }

    public static String getErrorLogPath() {
        return "data/log_err";
    }

    public static boolean isForceDirty() {
        return forceDirty;
    }

    public static boolean isVerifyCache() {
        return verifyCache;
    }

    public static boolean isUseLessMemory() {
        return useLessMemory;
    }

    public static boolean isSkipFreeSpaceCheck() {
        return skipFreeSpaceCheck;
    }

    public static boolean isWarnNewClient() {
        return warnNewClient;
    }

    public static boolean isDisableBWM() {
        return disableBWM;
    }

    public static HentaiAtHomeClient getActiveClient() {
        return activeClient;
    }

    public static HathGUI getActiveGUI() {
        return activeGUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidRPCServer(InetAddress inetAddress) {
        Object object = rpcChangeMonitor;
        synchronized (object) {
            return true;
        }
    }

    public static boolean getUseProxy() {
        return proxyPort != -1;
    }

    public static Proxy getProxy() {
        Proxy proxy = proxyType == 0 ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)) : new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHost, proxyPort));
        return proxy;
    }

    public static int getMaxConnections() {
        if (overrideConns > 0) {
            return overrideConns;
        }
        int n = 0;
        int n2 = Stats.getUptime();
        if (throttle_bytes > 0) {
            n = 20 + throttle_bytes / 10000;
        } else if (n2 > 0) {
            n = (int)(Stats.getFilesSent() * 120L / (long)n2);
        }
        return Math.max(Math.min(500, n), 20);
    }

    public static boolean isStaticRange(String string) {
        if (staticRanges != null) {
            return staticRanges.containsKey(string.substring(0, 4));
        }
        return false;
    }

    public static int getStaticRangeCount() {
        if (staticRanges != null) {
            return staticRanges.size();
        }
        return 0;
    }

    static {
        clientID = 0;
        clientKey = "";
        serverTimeDelta = 0;
        rpcChangeMonitor = new Object();
        rpcServers = null;
        imageServer = "";
        clientName = "";
        clientHost = "";
        clientPort = 0;
        requestServer = "";
        requestProxyMode = 0;
        throttle_bytes = 0;
        hourbwlimit_bytes = 0L;
        disklimit_bytes = 0L;
        diskremaining_bytes = 0L;
        forceDirty = false;
        verifyCache = false;
        skipFreeSpaceCheck = false;
        warnNewClient = false;
        useLessMemory = false;
        disableBWM = false;
        proxyPort = -1;
        proxyType = 0;
        overrideConns = 0;
        datadir = null;
        staticRanges = null;
    }
}

